@rem $Novell: bldw32.bat,v 1.5 2003/01/14 20:06:05 $
@echo off

rem   A batch file for building LDAP samples or test programs on Win32 platforms
rem   using the Microsoft Visual C++ compiler.

rem   This relies on the Microsoft script VCVARS32.BAT to set up the PATH and
rem   environment variables for command line tools.


rem   You may want to customize settings marked with "***".

if "%1"=="" goto Usage

rem *** Base path for Novell NDK.    Set this for your environment.
set _NDK_BASE=C:\cldapvista

rem  *** If not already done, set up compiler command line tools.
rem  *** Edit this path for your system.
if "%VCINSTALLDIR%" == "" call "C:\Program Files (x86)\Microsoft Visual Studio 8\VC\bin\x86_amd64\vcvarsx86_amd64.bat"

rem *** A debug version of your program will be built if the environment
rem     variable DEBUG is defined.   i.e. SET DEBUG=Y

rem   Set path for LDAP libraries.
set _LDAP_LIB_PATH=%_NDK_BASE%\cldapsdk64\Win64\lib

rem   Set which LDAP libraries to use.
rem   All LDAP programs require LDAPSDK.  LDAPSSL and LDAPX are optional.
rem   This sample uses all three.
set _LDAP_LIBS=%_LDAP_LIB_PATH%\LDAPSDK.LIB

rem *** LDAPSSL is needed only if your program uses SSL encryption (ldapssl_xxx calls).
set _LDAP_LIBS=%_LDAP_LIBS% %_LDAP_LIB_PATH%\LDAPSSL.LIB

rem *** LDAPX is needed only if your program uses Novell LDAP extensions
set _LDAP_LIBS=%_LDAP_LIBS% %_LDAP_LIB_PATH%\LDAPX.LIB

set _obj=%_NDK_BASE%\cldapsdk64\samples\%1.obj

set _win_inc="C:\Program Files (x86)\Microsoft Visual Studio 8\VC\include"
set _win_inc=%_win_inc% -I "C:\Program Files (x86)\Microsoft Visual Studio 8\VC\PlatformSDK\Include"

rem  Compiler flags
rem   /c  - Compile to an object file
rem   /W3 - Display warning messages
rem   /MT - Create a multi-threaded executable using LIBCMT.LIB
rem   /nologo - Suppress sign-on banner
rem   /TP - Compile as .cpp file
rem   /DWIN32 - Define symbol WIN32
rem   /Od - (DEBUG) Suppress optimization
rem   /Z7 - (DEBUG) Produce C7.0-style debug information
set _COMP_FLAGS=/D_WIN64 /D_AMD64_ /DLDAP_R_COMPILE /DHAVE_NT_THREADS /DNMAS_SUPPORT /DNOVELL_THREAD_SAFE /D_UNICODE /DN_INC_NO_OLD_MACROS /D_CRT_SECURE_NO_DEPRECATE /c /X /w /WX /GF /Gy /MT /GS /nologo /Wp64 /TC /DN_PLAT_WIN64 /Fo%_obj% 

if NOT "%DEBUG%" == ""  set _COMP_FLAGS=%_COMP_FLAGS% /Z7 /Od
set _INC_PATHS=%_NDK_BASE%\cldapsdk64\Win64\inc 


rem  Linker flags
rem   /nologo - Suppress sign-on banner
rem   /DEBUG - For building a debug version
rem   /DEBUGTYPE:BOTH  /PDB:NONE - Build debugging information into the EXE file
set _LINK_FLAGS=/nologo /MACHINE:X64 /NODEFAULTLIB 
if NOT "%DEBUG%" == ""  set _LINK_FLAGS=%_LINK_FLAGS% /DEBUG /DEBUGTYPE:BOTH /PDB:NONE 
set _MSLIBS="C:\Program Files (x86)\Microsoft Visual Studio 8\VC\PlatformSDK\Lib\AMD64\KERNEL32.LIB" "C:\Program Files (x86)\Microsoft Visual Studio 8\VC\lib\amd64\LIBCMT.LIB" "C:\Program Files (x86)\Microsoft Visual Studio 8\VC\lib\amd64\oldnames.lib" 


echo.
echo   Building LDAP program ...

echo COMPILING.........
cl %_COMP_FLAGS% -I%_win_inc%  -I%_INC_PATHS%  %1.c
if ERRORLEVEL 1 goto done
echo LINKING...........
link  %_LINK_FLAGS% %1.obj %_LDAP_LIBS% %_MSLIBS%

if ERRORLEVEL 1 goto done


echo   Build complete.

:done
rem del %1.obj 2>nul
set _NDK_BASE=
set _INC_PATHS=
set _LDAP_LIB_PATH=
set _LDAP_LIBS=
set _COMP_FLAGS=
set _LINK_FLAGS=
set _MSLIBS=
exit /B %ERRORLEVEL%

:Usage
echo.
echo Usage:  bldw64 filename  (with no extension.  Assumes .c)
echo    Builds a program with Novell's LDAP Libraries for C for Win64.
echo.
echo    This file should be edited to set paths appropriate to your environment.
exit /B 1

