/**************************************************************************
** Copyright (c) 1992 Novell, Inc.  All Rights Reserved.
**
** THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
** TREATIES.  USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE
** LICENSE AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK)
** THAT CONTAINS THIS WORK.
** 
** Pursuant to the SDK License Agreement, Novell hereby grants to
** Developer a royalty-free, non-exclusive license to include the
** sample code CUSTINFO.CPP and derivative binaries in its product.
** Novell grants to Developer worldwide distribution rights to market,
** distribute or sell the sample code CUSTINFO.CPP and derivative
** binaries as a component of Developer's product(s).  Novell shall
** have no obligations to Developer or Developer's customers with
** respect to this code.
** 
** DISCLAIMER:
** 
** 	Novell, Inc. makes no representations or warranties with respect
** to the contents or use of this code, and specifically disclaims any
** express or implied warranties of merchantability or fitness for any
** particular purpose.  Further, Novell, Inc. reserves the right to revise
** this publication and to make changes to its content, at any time,
** without obligation to notify any person or entity of such revisions or
** changes.
**
** 	Further, Novell, Inc. makes no representations or warranties with
** respect to any software, and specifically disclaims any express or
** implied warranties of merchantability or fitness for any particular
** purpose.  Further, Novell, Inc. reserves the right to make changes to
** any and all parts of the software, at any time, without obligation to
** notify any person or entity of such changes.
**
***************************************************************************
** File Name  :	CUSTINFO.CPP
** Description: This sample code demonstrates how to use the new 
**              connection services calls.
**
** Programmer:  Karl Bunnell
** Date:        02/22/96
*/

#include <stdio.h>
#include <stdlib.h>
#include <nwcalls.h>
#include <nwclxcon.h>
#include <nwfse.h>
#include <ntypes.h>


void main()
{
   NWRCODE        ccode;
   NWRCODE        scanCode = 0;
   NWCONN_HANDLE  connHandle;
   nuint32        scanIt = 0;
   nuint32        connRef;
   NWCCConnInfo   connInfoBuf;
   NWCCConnInfo   connInfoBuf2;
   char           serverName[48];
   nuint8         majorVersion;
   nuint8         minorVersion;
   nuint8         revision;


   /* Library Initialization */
   ccode = NWCallsInit(NULL,NULL);
   if (ccode)
   {
      printf("NWCallsInit failed with error code=0x%04x\n", ccode);
      return;
   }
   ccode = NWCLXInit(NULL,NULL);
   if (ccode)
   {
      printf("NWCLXInit failed with error code=0x%04x\n", ccode);
      return;
   }

   while (scanCode != NWE_NO_MORE_ENTRIES)
   {
      /* Get the next connection reference */
      scanCode = NWCCScanConnRefs(
                                 /* scan iter   */ &scanIt,
                                 /* conn ref    */ &connRef
                                 );

      if (scanCode && scanCode != NWE_NO_MORE_ENTRIES)
      {
         printf("NWCCScanConnRefs failed with error code=0x%04x\n", scanCode);
      }


      /* Demonstrate retrieval of connection reference information */
      ccode = NWCCGetAllConnRefInfo(
                                   /* conn ref        */ connRef,
                                   /* conn Ver info   */ NWCC_INFO_VERSION,
                                   /* conn info buffer*/ &connInfoBuf
                                   );

      if (ccode)
      {
         printf("NWCCGetAllConnRefInfo failed with error code=0x%04x\n", ccode);
         return;
      }

      printf(
"\n--------------------Connection Reference Information---------------------\n");

      printf("\nServer Name         : %s\n", connInfoBuf.serverName);
      printf("Tree Name           : %s\n", connInfoBuf.treeName);
      printf("Connection          : %d\n", connInfoBuf.connNum);
      printf("Authentication State: %s\n", 
             (connInfoBuf.authenticationState & NWCC_AUTHENT_STATE_NDS) 
             ? "NDS" : "BIND");
      printf("NDS Capable         : %s\n", 
             (connInfoBuf.NDSState & NWCC_NDS_CAPABLE) ? "Yes" : "No");
      printf("Licensed State      : ");

      if (connInfoBuf.licenseState & NWCC_NOT_LICENSED)
         printf("Not Licensed");

      if (connInfoBuf.licenseState & NWCC_CONNECTION_LICENSED)
         printf("Connection Licensed");

      if (connInfoBuf.licenseState & NWCC_HANDLE_LICENSED)
         printf("Handle Licensed");

      printf("\nMax Packet Size     : %d\n", connInfoBuf.maxPacketSize);
      printf("Distance            : %d\n", connInfoBuf.distance);


      /* 
       *  Get the server version number using NWGetFileServerInformation -
       *  requires a connection handle.
       */
      ccode = NWCCOpenConnByRef(
                               /* conn ref     */  connRef,
                               /* open state   */  NWCC_OPEN_LICENSED,
                               /* reserved     */  NWCC_RESERVED,
                               /* conn handle  */  &connHandle
                               );
      if (ccode)
      {
         printf("NWCCOpenConnByRef failed with error code=0x%04x\n", ccode);
         return;
      }
      ccode = NWGetFileServerInformation(
                                     /* Connection handle    */ connHandle,
                                     /* Server Name          */ serverName,
                                     /* major version        */ &majorVersion,
                                     /* minor version        */ &minorVersion,
                                     /* revision             */ &revision,
                                     /* max connections      */ NULL,
                                     /* Max Connections used */ NULL,
                                     /* Connections in use   */ NULL,
                                     /* Number of volumes    */ NULL,
                                     /* SFTLevel             */ NULL,
                                     /* TTSLevel             */ NULL
                                        );

      if (ccode)
      {
         printf("NWGetFileServerInformation failed with error code=0x%04x\n\n", 
                ccode);
         NWCCCloseConn (connHandle);
         return;
      }
      printf("%s %d.%d %d \n", 
             serverName, majorVersion, minorVersion, revision);
      ccode = NWCCCloseConn(connHandle);
      if (ccode)
      {
         printf("NWCCCloseConn failed with error code=0x%04x\n\n", ccode);
         return;
      }


      /* Demonstrate retrieval of connection handle information */
      ccode = NWCCOpenConnByName (
                        /* NWCONN_HANDLE     */    0,
                        /* pnstr8            */    connInfoBuf.serverName,
                        /* NWCCNameFormat    */    NWCC_NAME_FORMAT_BIND,
                        /* NWCCOpenState     */    NWCC_OPEN_UNLICENSED,
                        /* NWCCReserved      */    NWCC_RESERVED,
                        /* NWCONN_HANDLE     */    &connHandle
                                 );

      if (ccode)
      {
         printf("NWCCOpenConnByName failed with error code=0x%04x\n", ccode);
         return;
      }

      ccode = NWCCGetAllConnInfo(
                                /* conn Handle   */ connHandle,
                                /* conn info ver */ NWCC_INFO_VERSION,
                                /* conn info Buf */ &connInfoBuf2
                                );

      if (ccode)
      {
         printf("NWCCGetAllConnInfo failed with error code=0x%04x\n", ccode);
         NWCCCloseConn(connHandle);
         return;
      }

      printf(
"\n--------------------Connection Handle Information------------------------\n");

      printf("\nServer Name         : %s\n", connInfoBuf2.serverName);
      printf("Tree Name           : %s\n", connInfoBuf2.treeName);
      printf("Connection          : %d\n", connInfoBuf2.connNum);
      printf("Authentication State: %s\n", 
             (connInfoBuf2.authenticationState & NWCC_AUTHENT_STATE_NDS) ? "NDS" : "BIND");
      printf("NDS Capable         : %s\n", 
             (connInfoBuf2.NDSState & NWCC_NDS_CAPABLE) ? "Yes" : "No");
      printf("Licensed State      : ");

      if (connInfoBuf2.licenseState & NWCC_NOT_LICENSED)
         printf("Not Licensed");

      if (connInfoBuf2.licenseState & NWCC_CONNECTION_LICENSED)
         printf("Connection Licensed");

      if (connInfoBuf2.licenseState & NWCC_HANDLE_LICENSED)
         printf("Handle Licensed");

      printf("\nMax Packet Size     : %d\n", connInfoBuf2.maxPacketSize);
      printf("Distance            : %d\n", connInfoBuf2.distance);

      ccode = NWCCCloseConn(connHandle);
      if (ccode)
      {
         printf("NWCCCloseConn failed with error code=0x%04x\n\n", ccode);
         return;
      }

   } /* end-while */
}
