/*************************************************************************

  Copyright (c) 1995 1997 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose. */

/**************************************************************************
   OBJ_CONN.C
***************************************************************************

 OBJ_CONN.C returns the connection numbers for a specified user on a
 specified server.  OBJ_CONN uses the flag OT_USER which scans for the
 Bindery object type "user".  The function does not scan for connections
 of full NDS names (example: wcoyote.sales.acme)

**************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ntypes.h>
#include <nwcalls.h>
#include <nwnet.h>

int main (int argc, char *argv[])
{
   NWCCODE         ccode;
   NWCONN_HANDLE   connHandle;
   NWCONN_NUM      connList[50];   
   nuint16         suNumConns, i;
   nstr8           strServer[100], strUser[100];

   if(argc != 3)
   {
      printf ("Usage:  OBJ_CONN servername username\n");
      return(1);
   }

   /* Initialize libraries */
   ccode = NWCallsInit(NULL,NULL);
   if(ccode)    
   {
      printf("\nNWCallsInit returned %04X", ccode);
      return(1);
   }

   strcpy(strServer, strupr(argv[1]));
   strcpy(strUser, strupr(argv[2]));

   ccode = NWGetConnectionIDFromName(strlen(strServer), 
                                     (pnuint8)strServer, 
                                     &connHandle);
   if(ccode)
   {
      printf("NWGetConnectionIDFromName returned %04X\n", ccode);
      return(1);
   }

   ccode = NWGetObjectConnectionNumbers(
              /* Connection Handle  */   connHandle,
              /* Object name        */   strUser,
              /* Object type        */   OT_USER,
              /* # conns for object */   &suNumConns,
              /* array of conn nums */   connList,
              /* max size conn list */   50);
   if(ccode)
   {
      printf("NWGetObjectConnectionNumbers returned %04X\n", ccode);
      return(1);
   }

   printf ("\nConnections for user %s\n", strUser);
   for(i = 0; i < suNumConns; i++)
   {
      printf("%d\n", connList[i]);
   }

   return(0);
}

