/*************************************************************************

  Copyright (c) 1995, 1997 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose. */

/**************************************************************************
   EFFRIGHT.C
***************************************************************************

  EFFRIGHT.C is a small example application that displays the user's 
  effective rights for the given file name or directory.

  USAGE:  EFFRIGHT <path>

**************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ntypes.h>
#include <nwcalls.h>

int main (int argc, char *argv[])
{
   NWCCODE         ccode;
   NWCONN_HANDLE   conn;
   NWDIR_HANDLE    dirHandle;
   nuint16         suRights;
   nstr8           strOldPath[1024];
   nstr8           strNewPath[1024];

   if(argc != 2)
   {
      printf ("\nUsage:  EFFRIGHT <path>\n\n");
      printf ("exmpl:  EFFRIGHT MYSERVER\\MYVOL:\\DIRECTORY\\FILE.EXT\n");
      printf ("        EFFRIGHT F:\\DIRECTORY\\FILE.EXT\n");
      exit(1);
   }

   strcpy (strOldPath, strupr(argv[1]));

   /*  Initialize NWCalls */
   ccode = NWCallsInit(NULL,NULL);
   if(ccode)
   {
      printf("\nNWCallsInit returned %X", ccode);
      exit(1);
   }

   /* Get conn handle corresponding to path */
   ccode = NWParseNetWarePath (strOldPath,
                               &conn,
                               &dirHandle,
                               strNewPath);
   if (ccode)
   {
      printf ("NWParseNetWarePath returned %X\n", ccode);
      return(1);
   }

   /* read the effective rights */
   ccode = NWGetEffectiveRights(conn,
                                dirHandle,
                                strNewPath,
                                &suRights);
   if (ccode)
   {
      printf ("NWGetEffectiveRights returned %X\n", ccode);
      return(1);
   }

   /* print the effective rights */
   if (TR_READ & suRights) printf ("\nR");
   if (TR_WRITE & suRights) printf ("W");
   if (TR_CREATE & suRights) printf ("C");
   if (TR_DELETE & suRights) printf ("D");
   if (TR_OWNERSHIP & suRights) printf ("O");
   if (TR_FILE_SCAN & suRights) printf ("F");
   if (TR_MODIFY & suRights) printf ("M");
   printf ("  %s\n", strNewPath);

   return(0);
}

