/*************************************************************************

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose. */

/**************************************************************************
  DBPARSE.C
***************************************************************************

  Sample double-byte enabled string parsing example. This program shows 
  the use of NWLsetlocale, NWLlocaleconv, NWNextChar, and NWPrevChar.
  This simple program:
     a)  Initializes the locale
     b)  Displays the current country code and code page
     c)  Replaces all occurrences of forward slash with backslash
         in a test string.
     d)  If the last character of the test string is a backslash,
         removes it.

  Output:
     Current country_id:   1
     Current code_page:    437
     Initial test string:  C:/user/temp/
     Final   test string:  C:\user\temp

**************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <ntypes.h>
#include <nwlocale.h>

int main(void)
{  
   nstr8 test_string[] = "C:/user/temp/";
   pnstr8 p;
   LCONV  lconvStruct;

   NWLsetlocale(NLC_ALL,"");     /* Initialize locale.      */
   NWLlocaleconv(&lconvStruct);  /* Get locale information. */

   NWprintf("Current country_id:   %d\n",lconvStruct.country_id);
   NWprintf("Current code_page:    %d\n\n",lconvStruct.code_page);
   NWprintf("Initial test string:  %s\n", test_string);

   /* Replace all forward slashes with backslashes. */
   p = test_string;

   while(*p)
   {
      if(*p == '/')
         *p = '\\';
      p = NWNextChar(p);  /*  Do this, not p++ */
   }

   /* If last character of string is backslash, remove it.    */
   p = NWPrevChar(test_string,p);   /* Back up one character. */

   if(*p == '\\')
      *p = '\0';

   NWprintf("Final   test string:  %s\n", test_string);

   return(0);
}

