/*************************************************************************

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose. */

/**************************************************************************
  EXGNOMAP.C
**************************************************************************/

#include <nunicode.h>
#include <stdio.h>

void main(void)
{
   pCONVERT pconv;
   nint     icode;
   nint     byteAction, uniAction;

   /* Load a byte/uni converter for the current code page.
      Error checking not shown. */
   icode = NWUXLoadByteUnicodeConverter(0, &pconv);

   icode = NWUXGetNoMapAction(pconv, &byteAction, &uniAction);
   if (icode)
      printf("NWUXGetNoMapAction returned error 0x%04X\n",icode);
   else
   {
      printf("NoMap action for unmappable bytes:  ");
      switch (byteAction)
      {
        case NWU_RETURN_ERROR: printf("Return an error\n");  break;
        case NWU_SUBSTITUTE:   printf("Use substitute uni char\n"); break;
        case NWU_CALL_HANDLER: printf("Call handler function\n"); break;
      }

      printf("NoMap action for unmappable unicode characters:  ");
      switch (uniAction)
      {
        case NWU_RETURN_ERROR:  printf("Return an error\n");  break;
        case NWU_SUBSTITUTE:    printf("Use substitute byte\n"); break;
        case NWU_CALL_HANDLER:  printf("Call handler function\n"); break;
      }
   }

   NWUXUnloadConverter(pconv);
}

/* Output (default behavior):
  NoMap action for unmappable bytes:  Use substitute uni char
  NoMap action for unmappable unicode characters:  Call handler function
*/



