/*************************************************************************

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose. */

/*************************************************************************
  EXLDBU.C
**************************************************************************

  Load a converter for byte-to-uni and uni-to-byte conversions. 
  
*************************************************************************/

#include <nunicode.h>
#include <stdio.h>
#include <stdlib.h>

void main(void)
{
   nint     icode;
   pCONVERT pconv;
   nuint    uCodePage;

/* Example 1:
   Specifying code page=0 causes the current code page to be used. */

   icode = NWUXLoadByteUnicodeConverter(0, &pconv);

   if (icode)  /* If error, display the current code page in message. */
   {
      NWUSGetCodePage(&uCodePage, NULL);
      printf("Unable to load converter for current code page %d\n"
             ,uCodePage);
      printf("Error code %04X\n",icode);

      exit(icode);
   }

   /*   Do something here...  */

   /* Release the converter. */
   NWUXUnloadConverter(pconv);


/* Example 2:
   Load an converter for an explicit code page. */

   uCodePage = 437;       /* 437 is the U.S. OEM code page */
   icode = NWUXLoadByteUnicodeConverter(uCodePage, &pconv);

   if (icode)
   {
      printf("Unable to load converter for code page %d\n"
             ,uCodePage);
      printf("Error code %04X\n",icode);

      exit(icode);
   }

   /*   Do something here...  */

   /* Unload the converter. */
   NWUXUnloadConverter(pconv);

} 

