/*************************************************************************

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose. */

/**************************************************************************
  EXSSUBU.C
***************************************************************************

  Change the substitution unicode character to use in
  uni-to-byte conversions. 

**************************************************************************/

#include <nunicode.h>
#include <stdio.h>
#include <assert.h>
#include <string.h>

void main(void)
{
   pCONVERT pconv;
   nint     icode;
   nuint    actualLen;
   nuint8   subUni = '?';   /* Change the substitution uni char to '?' */
   nuint8   byteIn[5] = { 'a', 'b', 'c', 0x81, 0 };    /* Test string  */
   unicode  uniOut[80];

   /* Load a byte/uni converter.  Use an ANSI codepage 1252 since it has
      some unmappable bytes. Error checking not shown. */
   icode = NWUXLoadByteUnicodeConverter(1252, &pconv);

   /* The default action for unmappable bytes is to use a substitute
      unicode character.  There is no need to call NWUXSetNoMapAction */

   icode = NWUXSetSubUni(pconv, subUni);
   if (icode)
      printf("NWUXSetSubUni returned error 0x%04X\n",icode);

   /* This conversion should produce the unicode string "abc?" */
   icode = NWUXByteToUnicode(pconv, uniOut, 80, byteIn, &actualLen);
   assert(icode == 0  &&  uniOut[3] == '?' && actualLen == 4);

   NWUXUnloadConverter(pconv);
} 


