/*************************************************************************

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose. */

/**************************************************************************
  EXUNL.C
***************************************************************************

  Example of unloading converters.  

**************************************************************************/

#include <nunicode.h>
#include <stdio.h>

void main(void)
{
   nint     icode;
   pCONVERT pbuConv;
   pCONVERT pCaseConv;

/* Load a byte-to-uni converter and case converter. */

   icode = NWUXLoadByteUnicodeConverter(0, &pbuConv);
   /* Error checking not shown */

   icode = NWUXLoadCaseConverter(NWU_LOWER_CASE, &pCaseConv);
   /* Error checking not shown */

   /*   Do something here...  */

   /*
      Unload both of the converters.
      Error checking may be done, but is not normally necessary.
   */

   icode = NWUXUnloadConverter(pbuConv);
   if (icode)
      printf("Error unloading byte-to-uni converter:  %04X\n", icode);

   icode = NWUXUnloadConverter(pCaseConv);
   if (icode)
      printf("Error unloading case converter:  %04X\n", icode);
}  

