#include <stdio.h>

#include "nwcalls.h"

#define BUFFER_SIZE 512

int main(void)
{
	NWCCODE ccode;
	nuint32 handle;
	nuint32 bufLen = BUFFER_SIZE;
	nstr    buffer[BUFFER_SIZE];


	ccode = NWCallsInit(NULL, NULL);

	if (ccode) 
   {
		printf("\nNWCallsInit: failed %04x",ccode);
		return -1;
	}

   /* List of all the trees we can see */
	ccode = NWGetObjectNamesBeginA(OT_TREE_NAME, &handle);
	if(0 == ccode)
	{
		do
		{
			ccode = NWGetObjectNamesNextA(handle, &bufLen, buffer);
			if(0 == ccode)
				printf("%s\n", buffer);
			else if(NO_MORE_ENTRIES == ccode)
				printf("End of tree list\n");
			else
				printf("Something wrong with NWGetObjectNamesNextA.\n");
		}while(0 == ccode);

      /* 
         Following function is necessary even if NWGetObjectNamesNextA
         is failed.  It frees the resource allocated by 
         NWGetObjectNamesBeginA   
      */
		ccode = NWGetObjectNamesEndA(handle);
	}

  /* List of all the servers we can see */
	ccode = NWGetObjectNamesBeginA(OT_FILE_SERVER, &handle);
	if(0 == ccode)
	{
		do
		{
			ccode = NWGetObjectNamesNextA(handle, &bufLen, buffer);
			if(0 == ccode)
				printf("%s\n", buffer);
			else if(NO_MORE_ENTRIES == ccode)
				printf("End of server list\n");
			else
				printf("Something wrong with NWGetObjectNamesNextA.\n");
		}while(0 == ccode);

      /* 
         Following function is necessary even if NWGetObjectNamesNextA
         is failed.  It frees the resource allocated by 
         NWGetObjectNamesBeginA   
      */
		ccode = NWGetObjectNamesEndA(handle);
	}
	
   NWCallsTerm(NULL);
   return 0;
}