/*************************************************************************

  Copyright (c) 1995 1997 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a
  royalty-free, non-exclusive license to include this sample code
  and derivative binaries in its product. Novell grants to Developer
  worldwide distribution rights to market, distribute or sell this
  sample code file and derivative binaries as a component of
  Developer's product(s).  Novell shall have no obligations to
  Developer or Developer's customers with respect to this code.

  DISCLAIMER:

  Novell disclaims and excludes any and all express, implied, and
  statutory warranties, including, without limitation, warranties
  of good title, warranties against infringement, and the implied
  warranties of merchantibility and fitness for a particular purpose.
  Novell does not warrant that the software will satisfy customer's
  requirements or that the licensed works are without defect or error
  or that the operation of the software will be uninterrupted.
  Novell makes no warranties respecting any technical services or
  support tools provided under the agreement, and disclaims all other
  warranties, including the implied warranties of merchantability and
  fitness for a particular purpose. */

/**************************************************************************
   TIMEDATE.C
***************************************************************************

   TIMEDATE.C demonstrates NWUnpackDateTime() and NWPackDateTime()

**************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <ntypes.h>
#include <nwcalls.h>

/*-------------------------------------------------------------------
** Day parameters.  This is the bit breakdown for datebytes.
**       YYYYYYYMMMMDDDDD    They are masked with the following defines
**          7    4   5
**  The year is figured from 1980.
*/
#define DAY        0x001F
#define MONTH      0x01E0
#define YEAR       0xFE00
#define YRSTANDARD 1980

/*-------------------------------------------------------------------
** Time parameters.  This is the bit breakdown for timebytes.
**       HHHHHMMMMMMSSSSS  They are masked with the following defines.
**         5     6    5
*/
#define MINUTES 0x07E0
#define SECONDS 0x001F

/****************************************************************************
** Main program
*/
int main(void)
{
   nuint32   packedtime, temp;
   nuint16   timebytes;
   nuint16   datebytes;
   NW_DATE   nwd;
   NW_TIME   nwt;
   struct tm *t;
   time_t    ltime;

   /* Get the time */

   time(&ltime);
   t = localtime(&ltime);

   /* Make some adjustments.  The tm_mon field in tm begins at 0, while
      the corresponding field in NW_DATE begins with 1, therefore
      add 1 to tm_mon.

      The tm_year field holds the number of years since 1900, while the
      function NWPackDateTime expects the complete year, so add 1900.  */

   t->tm_mon  += 1;
   t->tm_year += 1900;

   /* Print date and time */

   printf("Date and time before packing  > %d/%d/%d   %d:%02d:%02d\n",
          t->tm_mon,
          t->tm_mday,
          t->tm_year,
          t->tm_hour,
          t->tm_min,
          t->tm_sec);

   /* Fill in the NW_DATE and NW_TIME structures */

   nwd.day     = t->tm_mday;
   nwd.month   = t->tm_mon;
   nwd.year    = t->tm_year;
   nwt.hours   = t->tm_hour;
   nwt.minutes = t->tm_min;
   nwt.seconds = t->tm_sec;

   packedtime = NWPackDateTime(
                              /* pointer to NW_DATE (IN)*/ &nwd,
                              /* pointer to NW_TIME (IN)*/ &nwt);

   /* Manipulate and read packedtime value */

   timebytes = (nuint16)packedtime;
   temp = packedtime>>16;
   datebytes = (nuint16)temp;

   printf("Date and time after packing   > %d/%d/%d     %d:%02d:%02d\n",
          (datebytes & MONTH) >> 5,
          (datebytes & DAY),
          (datebytes >> 9)+YRSTANDARD,
          (timebytes >> 11),
          (timebytes & MINUTES) >> 5,
          (timebytes & SECONDS) * 2);

   NWUnpackDateTime(
                   /* packed date and time */ packedtime,
                   /* pointer to NW_DATE   */ &nwd,
                   /* pointer to NW_TIME   */ &nwt);

   printf("Date and time after unpacking > %d/%d/%d   %d:%02d:%02d\n",
          nwd.month,
          nwd.day,
          nwd.year,
          nwt.hours,
          nwt.minutes,
          nwt.seconds);

   return(0);
}

