/********************************************************************

   Copyright (c) 1996 Novell, Inc.  All Rights Reserved.

   With respect to this file, Novell hereby grants to Developer a
   royalty-free, non-exclusive license to include this sample code
   and derivative binaries in its product. Novell grants to Developer
   worldwide distribution rights to market, distribute or sell this
   sample code file and derivative binaries as a component of
   Developer's product(s).  Novell shall have no obligations to
   Developer or Developer's customers with respect to this code.

   DISCLAIMER:

   Novell disclaims and excludes any and all express, implied, and
   statutory warranties, including, without limitation, warranties
   of good title, warranties against infringement, and the implied
   warranties of merchantability and fitness for a particular purpose.
   Novell does not warrant that the software will satisfy customer's
   requirements or that the licensed works are without defect or error
   or that the operation of the software will be uninterrupted.
   Novell makes no warranties respecting any technical services or
   support tools provided under the agreement, and disclaims all other
   warranties, including the implied warranties of merchantability and
   fitness for a particular purpose. */

/*********************************************************************
   NDSCONTX.C
**********************************************************************

   Description:

   This example creates an NDS context and then displays many
   of the context settings, including DCK_FLAGS, DCK_CONFIDENCE
   and DCK_REFERRAL_SCOPE

*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <nwcalls.h>
#include <nwnet.h>
#include <nwlocale.h>

/* functions */
void ShowNameContext(NWDSContextHandle context);
void ShowFlags(NWDSContextHandle context);
void ShowConfidence(NWDSContextHandle context);
void ShowReferralScope(NWDSContextHandle context);

void main(void)
{
   NWDSCCODE          ccode;
   NWDSContextHandle  context;
   LCONV              lConvInfo;

   /* Initialize NWCalls and the unicode tables */
   ccode = NWCallsInit(NULL, NULL);
   if(ccode)
   {
      printf("\nNWCallsInit returned %X", ccode);
      exit(1);
   }

   NWLlocaleconv(&lConvInfo);

   ccode = NWInitUnicodeTables(lConvInfo.country_id,
                               lConvInfo.code_page);
   if(ccode)
   {
      printf("\nNWInitUnicodeTables error %X \n", ccode);
      exit(1);
   }

   /* Create a context with default settings. */
   ccode = NWDSCreateContextHandle(&context);
   if(ccode)
   {
      printf("\nNWDSCreateContextHandle failed");
      NWFreeUnicodeTables();
      exit(1);
   }
   else
      printf("\nNew context created with default settings:");

   ShowNameContext(context);
   ShowFlags(context);
   ShowConfidence(context);
   ShowReferralScope(context);

   /* Free the context before exiting. */
   ccode = NWDSFreeContext(context);
   if(ccode)
      printf("\n\nNWDSFreeContext returned %X", ccode);
   else
      printf("\n\nContext was freed\n");

   NWFreeUnicodeTables();
}

void ShowNameContext(NWDSContextHandle context)
{
   nstr8     strName[MAX_DN_CHARS+1];
   NWDSCCODE ccode;

   ccode = NWDSGetContext(context, DCK_NAME_CONTEXT, strName);
   if(ccode)
      printf("\nNWDSGetContext DCK_NAME_CONTEXT returned %X", ccode);
   else
      printf("\nCurrent Name Context: %s", strName);
}

void ShowFlags(NWDSContextHandle context)
{
   NWDSCCODE ccode;
   nuint32   luFlags;

   ccode = NWDSGetContext(context, DCK_FLAGS, &luFlags);
   if(ccode)
      printf("\nNWDSGetContext DCK_FLAGS returned %d", ccode);
   else
   {
      printf("\n\nDCK_FLAGS is set to:                   %d",
             luFlags);
      printf("\n  The bit for DCV_DEREF_ALIASES is:      %s",
             (luFlags & DCV_DEREF_ALIASES)? "ON": "OFF");
      printf("\n  The bit for DCV_XLATE_STRINGS is:      %s",
             (luFlags & DCV_XLATE_STRINGS)? "ON": "OFF");
      printf("\n  The bit for DCV_TYPELESS_NAMES is:     %s",
             (luFlags & DCV_TYPELESS_NAMES)? "ON": "OFF");
      printf("\n  The bit for DCV_ASYNC_MODE is:         %s",
             (luFlags & DCV_ASYNC_MODE)? "ON": "OFF");
      printf("\n  The bit for DCV_CANONICALIZE_NAMES is: %s",
             (luFlags & DCV_CANONICALIZE_NAMES)? "ON": "OFF");
   }
}

void ShowConfidence(NWDSContextHandle context)
{
   NWDSCCODE  ccode;
   nuint32    luConfidence;
   pnstr8     levels[] = {"DCV_LOW_CONF (0)",
                          "DCV_MED CONF (1)",
                          "DCV_HIGH_CONF (2)"};

   ccode = NWDSGetContext(context, DCK_CONFIDENCE, &luConfidence);
   if(ccode)
      printf("\nNWDSGetContext DCK_CONFIDENCE returned %d", ccode);
   else
      printf("\n\nDCK_CONFIDENCE set to: %s", levels[luConfidence]);
}

void ShowReferralScope(NWDSContextHandle context)
{
   NWDSCCODE  ccode;
   nuint32    luScope;
   pnstr8     scopes[] = {"DCV_ANY_SCOPE (0)",
                          "DCV_COUNTRY_SCOPE (1)",
                          "DCV_ORGANIZATION_SCOPE (2)"
                          "DCV_LOCAL_SCOPE (3)"};

   ccode = NWDSGetContext(context, DCK_REFERRAL_SCOPE, &luScope);
   if(ccode)
      printf("\nNWDSGetContext DCK_REFERRAL_SCOPE returned %d",ccode);
   else
      printf("\n\nDCK_REFERRAL_SCOPE is set to: %s",scopes[luScope]);
}

