/**************************************************************************
   SYNCSTRT.C
***************************************************************************

  This module shows how to suspend the console process from loading
  other NLMs or executing additional .NCF commands until your NLM calls
  SynchronizeStart().

  NOTES:  1. The OPTION SYNCHRONIZE option must be used in order
             to tell the loader to suspend itself until we call the
             SynchronizeStart API.

             The following command shows how to use QMK386 to generate
          a Watcom makefile with OPTION SYNCHRONIZE:

                QMK386 SYNCSTRT /ns

          2. Warning, DO NOT LOAD OTHER NLMs (i.e. spawn(...)) WHILE
             THE CONSOLE IS SUSPENDED.  YOU'LL LOCK UP IF YOU DO...

          3. To test this option, create an NCF with the following
             commands:

                LOAD SYNCSTRT
                VOLUMES
                LOAD MONITOR

             Notice that the VOLUMES command is NOT executed, nor is the
             MONITOR NLM loaded until you press a key...

             The example NCF file above assumes that SYNCSTRT.NLM is
             located in the server's search path (see SEARCH command).
             If not, the test won't behave properly.  If this is a
             problem, either copy SYNCSTRT.NLM into the search path or
             modify the NCF file to find SYNCSTRT.NLM (example: make
             line 1 of the NCF file read "LOAD A:\SYNCSTRT" to load the
             NLM from drive A).
**************************************************************************/
#include <stdio.h>
#include <nwconio.h>

int main(void)
{
   printf("Notice that the Console appears to be locked...\n");
   getch();
   printf("Calling SyncronizeStart...\n");
   SynchronizeStart();
   SetAutoScreenDestructionMode(TRUE);

   return(0);
}
