/*************************************************************************
Copyright  1999-2002 Novell, Inc. All Rights Reserved. 

THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND 
TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE
AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS
THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS
TO DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S
SAMPLE CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION
RIGHTS TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT
OF DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR
DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

***************************************************************************/
/*******************************************************************
* Name: Base64Codec.h
* Description: collection of functions to encode/decode to/from
* base64 encoding.
* Tabs: 4
*******************************************************************/
#ifndef _BASE64CODEC_H_
#define	_BASE64CODEC_H_

#include	"NativeInterface.h"

#if	defined(_WIN32)
#define IFAPI	__stdcall
#else
#define	IFAPI
#endif

#if defined(__cplusplus)
extern "C" {
#endif

//++
//=============================================================================
// Method:	Base64Codec_encode
// Desc:	Encode an array of bytes as a null-terminated string of UTF-16
//			characters using base64 encoding.
// 
// Notes:
//			The returned string must be freed via a call to base64EncodeFree()
//=============================================================================
DIRXML_EXPORT
unicode * IFAPI						//pointer to UTF-16 string
Base64Codec_encode(
unsigned char * data,				//array of bytes to be encoded
int off,							//starting offset in array
int len);							//number of bytes to encode
//--

//++
//=============================================================================
// Method:	Base64Codec_encodeFree
// Desc:	Free a string returned from base64Encode()
// 
// Notes:
//=============================================================================
DIRXML_EXPORT
void IFAPI
Base64Codec_encodeFree(
unicode * encodedData);	//pointer to UTF-16 string returned from base64Encode
//--

//++
//=============================================================================
// Method:	Base64Codec_decode
// Desc:	Decode binary data from a UTF-16 string containing the data encoded
//			in base64.
// 
// Notes:
//			The returned array must be freed via a call to base64DecodeFree()
//			If the input data is malformed, 0 is returned
//=============================================================================
DIRXML_EXPORT
unsigned char * IFAPI				//pointer to array of bytes containing decoded data (0 if malformed encodedData)
Base64Codec_decode(
const unicode * encodedData,		//pointer to UTF-16 string containing base64-encoded data
int * decodedLength);				//pointer to int to receive length of decoded data
//--

//++
//=============================================================================
// Method:	Base64Codec_decodeFree
// Desc:	Free a string returned from base64Decode()
// 
// Notes:
//=============================================================================
DIRXML_EXPORT
void IFAPI
Base64Codec_decodeFree(
unsigned char * decodedData);		//pointer to array returned from base64Decode
//--

#if defined(__cplusplus)
}
#endif

#endif	//#ifndef _BASE64CODEC_H_
