/*************************************************************************
Copyright  1999-2002 Novell, Inc. All Rights Reserved. 

THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND 
TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE
AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS
THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS
TO DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S
SAMPLE CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION
RIGHTS TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT
OF DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR
DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

***************************************************************************/
#ifndef _DRIVERFILTER_H_
#define	_DRIVERFILTER_H_

#include	"define_interface.h"

//NOTE: can't use wchar_t because it is 32-bits on Solaris
typedef unsigned short unicode;

INTERFACE_FWD_DECL(ClassFilter);

//++
/*****************************************************************
Interface: DriverFilter
Desc:
	This interface allows use of the Subscriber or Publisher filter

Notes: 

*****************************************************************/
INTERFACE(DriverFilter)
//--

	//++
	//=========================================================================
	// Method:	passClass
	// Desc:	return non-zero if the passed class is in the filter
	// 
	// Notes:	
	//=========================================================================
	METHOD(DriverFilter, passClass, int)		//non-zero return indicates passed class is in the filter
		METHOD_PARM1(const unicode * className)	//name of class to test
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	getClassFilter
	// Desc:	return the ClassFilter for the passed class
	// 
	// Notes:	
	//=========================================================================
	METHOD(DriverFilter, getClassFilter, ClassFilter *)	//return is ClassFilter or zero
		METHOD_PARM1(const unicode * className)			//name of class for which to get ClassFilter
	END_METHOD
	//--

END_INTERFACE(DriverFilter)

//++
/*****************************************************************
Interface: ClassFilter
Desc:
	This interface allows use of the Subscriber or Publisher filter

Notes: 

*****************************************************************/
INTERFACE(ClassFilter)
//--

	//++
	//=========================================================================
	// Method:	passAttribute
	// Desc:	return non-zero if the passed attribute is in the class filter
	// 
	// Notes:	
	//=========================================================================
	METHOD(ClassFilter, passAttribute, int)		//non-zero return indicates passed attribute is in the filter
		METHOD_PARM1(const unicode * attrName)	//name of attribute to test
	END_METHOD
	//--

END_INTERFACE(ClassFilter)


#if !defined(__cplusplus)

#define DriverFilter_passClass(_this,cName)\
	(*_this->vTbl->passClass)(_this,cName)

#define DriverFilter_getClassFilter(_this,cName)\
	(*_this->vTbl->getClassFilter)(_this,cName)

#define ClassFilter_passAttribute(_this,aName)\
	(*_this->vTbl->passAttribute)(_this,aName)

#endif	//if !defined(__cplusplus)


#endif	//#ifndef _DRIVERFILTER_H_
