/*************************************************************************
Copyright  1999-2002 Novell, Inc. All Rights Reserved. 

THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND 
TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE
AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS
THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS
TO DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S
SAMPLE CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION
RIGHTS TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT
OF DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR
DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

***************************************************************************/
#ifndef _INPUTSTREAM_H_
#define	_INPUTSTREAM_H_
#include	"define_interface.h"

//++
/*****************************************************************
Interface: InputStream
Desc:
	An interface for reading bytes from a byte stream

Notes:
*****************************************************************/
INTERFACE(InputStream)
//--

	//++
	//=========================================================================
	// Method:	close
	// Desc:	Close the input stream
	// 
	// Notes:	
	//=========================================================================
	METHOD(InputStream, close, void)
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	read
	// Desc:	read a single byte from the stream
	// 
	// Notes:	
	//			returns -1 when EOF reached
	//=========================================================================
	METHOD(InputStream, read, int)				//byte read, or -1
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	read
	// Desc:	read multiple bytes from the stream
	// 
	// Notes:
	//			may return few than len bytes if EOF reached
	//=========================================================================
	METHOD(InputStream, read, int)				//number of bytes read
		METHOD_PARM1(unsigned char * b)			//buffer to contain bytes read
		METHOD_PARM(int off)					//offset into b 
		METHOD_PARM(int len)					//number of bytes to read
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	skip
	// Desc:	skip n bytes without reading
	// 
	// Notes:
	//			may return a value less than n if n would skip beyond EOF
	//=========================================================================
	METHOD(InputStream, skip, long)				//number of bytes skipped
		METHOD_PARM1(long n)					//number of bytes to skip
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	markSupported
	// Desc:	return non-zero if mark()/reset() supported
	// 
	// Notes:
	//
	//=========================================================================
	METHOD(InputStream, markSupported, int)		//non-zero if mark()/reset() supported
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	mark
	// Desc:	if mark()/reset() are supported, mark current location in
	//			stream and remember all bytes read until reset is called.
	// 
	// Notes:
	//			if more than readlimit bytes are read then mark can become
	//			invalid
	//=========================================================================
	METHOD(InputStream, mark, int)				//zero if mark not supported
		METHOD_PARM1(int readlimit)				//max bytes to allow before mark is invalidated
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	reset
	// Desc:	if mark()/reset() are supported, return to marked location in
	//			input stream
	// 
	// Notes:
	//			returns 0 if not marked, mark is invalid, or mark not supported
	//=========================================================================
	METHOD(InputStream, reset, int)				//zero if mark not supported or stream not marked
	END_METHOD

	//++
	//=========================================================================
	// Method:	destroy
	// Desc:	destroy the instance implementing InputStream
	// 
	// Notes:
	//=========================================================================
	METHOD(InputStream, destroy, void)
	END_METHOD
	//--

END_INTERFACE(InputStream)



#endif	//#ifndef _INPUTSTREAM_H_
