/*************************************************************************
Copyright  1999-2002 Novell, Inc. All Rights Reserved. 

THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND 
TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE
AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS
THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS
TO DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S
SAMPLE CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION
RIGHTS TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT
OF DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR
DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

***************************************************************************/
#ifndef _INTERFACEFACTORY_H_
#define	_INTERFACEFACTORY_H_

#include	"sax.h"
#include	"dom.h"
#include	"NativeInterface.h"
#include	"DriverFilter.h"
#include	"Trace.h"
#include	"InputStream.h"
#include	"XmlWriter.h"
#include	<stdio.h>		//for FILE

#if	defined(_WIN32)
#define IFAPI	__stdcall
#else
#define	IFAPI
#endif

#if	defined(__cplusplus)
extern "C"
{
#endif

//++
//=============================================================================
// Method:	Document_new
// Desc:	Return a new DOM Document instance
// 
// Notes:	See dom.h
//
//			The returned interface must be freed via a call to its
//			destroy() method or by a call to Document_destroyInstance() when finished.
//=============================================================================
DIRXML_EXPORT
NAMESPACE(DOM)Document * IFAPI		//pointer to Document interface
Document_new();
//--

//++
//=============================================================================
// Method:	Document_destroyInstance
// Desc:	Destroy an interface returned from Document_new
// 
// Notes:	See dom.h
//
//=============================================================================
DIRXML_EXPORT
void IFAPI
Document_destroyInstance(
	NAMESPACE(DOM)Document * document);
//--

//++
//=============================================================================
// Method:	Parser_new
// Desc:	Return a new SAX Parser instance
// 
// Notes:	see sax.h
//
//			The returned interface must be freed via a call to
//			Parser_destroy() when finished.
//=============================================================================
DIRXML_EXPORT
NAMESPACE(SAX)Parser * IFAPI			//pointer to Parser interface
Parser_new();
//--

//++
//=============================================================================
// Method:	Parser_destroy
// Desc:	Destroy a SAX Parser instance returned from Parser_new()
// 
// Notes:	see sax.h
//
//=============================================================================
DIRXML_EXPORT
void IFAPI
Parser_destroy(
	NAMESPACE(SAX)Parser * parser);		//pointer to interface returned from Parser_new()
//--

//++
//=============================================================================
// Method:	InputSource_new
// Desc:	Return a new SAX InputSource instance for use with an instance
//			of SAX Parser.
// 
// Notes:	see sax.h
//
//			The returned interface must be freed via a call to
//			InputSource_destroy() when finished.
//=============================================================================
DIRXML_EXPORT
NAMESPACE(SAX)InputSource * IFAPI		//pointer to InputSource interface
InputSource_new();
//--

//++
//=============================================================================
// Method:	InputSource_destroy
// Desc:	Destroy a SAX InputSource instance returned from InputSource_new()
// 
// Notes:	see sax.h
//
//=============================================================================
DIRXML_EXPORT
void IFAPI
InputSource_destroy(
	NAMESPACE(SAX)InputSource * inputSource);	//pointer to interface returned from InputSource_new()
//--

//++
//=============================================================================
// Method:	XmlDocument_newFromBytes
// Desc:	Create a new XmlDocument instance from an array of bytes
// 
// Notes:	see NativeInterface.h
//
//			The returned instance must be destroyed with a call to
//			XmlDocument_destroy()
//
//			The XmlDocument instance does NOT take ownership of the passed
//			byte array and so it must be freed AFTER the XmlDocument
//			instance is destroyed.
//=============================================================================
DIRXML_EXPORT
XmlDocument * IFAPI					//pointer to XmlDocument interface
XmlDocument_newFromBytes(
	const unsigned char * bytes,	//pointer to array of bytes with serialized XML document
	int length,						//length of byte array
	const unicode * encoding,		//0-terminated unicode string with name of character encoding of byte array
	int endian);					//byte-order of encoding in byte array, 0 for Intel, non-zero for Motorola
//--

//++
//=============================================================================
// Method:	XmlDocument_newFromDOM
// Desc:	Create a new XmlDocument instance from a DOM tree
// 
// Notes:	see NativeInterface.h
//
//			The returned instance must be destroyed with a call to
//			XmlDocument_destroy()
//
//			The XmlDocument instance does NOT take ownership of the passed
//			DOM Document instance and so it must be freed AFTER the XmlDocument
//			instance is destroyed.
//=============================================================================
DIRXML_EXPORT
XmlDocument * IFAPI						//pointer to XmlDocument interface
XmlDocument_newFromDOM(
	NAMESPACE(DOM)Document * document);	//pointer to DOM Document interface
//--

//++
//=============================================================================
// Method:	XmlDocument_newFromSAX
// Desc:	Create a new XmlDocument instance from a SAX Parser and a
//			SAX InputSource
// 
// Notes:	see NativeInterface.h
//
//			The returned instance must be destroyed with a call to
//			XmlDocument_destroy()
//
//			The XmlDocument instance does NOT take ownership of the passed
//			SAX Parser instance or the passed SAX InputSource instance and
//			so they must be freed AFTER the XmlDocument instance is destroyed.
//=============================================================================
DIRXML_EXPORT
XmlDocument * IFAPI								//pointer to XmlDocument interface
XmlDocument_newFromSAX(
	NAMESPACE(SAX)Parser * parser,				//pointer to SAX Parser interface
	NAMESPACE(SAX)InputSource * inputSource);	//pointer to SAX InputSource interface
//--

//++
//=============================================================================
// Method:	XmlDocument_destroy
// Desc:	Destroy an XmlDocument instance returned from XmlDocument_new*
// 
// Notes:	see NativeInterface.h
//
//=============================================================================
DIRXML_EXPORT
void IFAPI
XmlDocument_destroy(
	XmlDocument * xmlDocument);					//pointer to interface returned from XmlDocument_new*()
//--

//++
//=============================================================================
// Method:	FileOutputStream_newFromName
// Desc:	Create a FileOutputStream object from a filename. Use with
//			XmlDocument::writeDocument() or XmlDocument::getXmlWriter()
// 
// Notes:	The passed filename will be opened using fopen(), mode "wb+"
//=============================================================================
DIRXML_EXPORT
OutputStream * IFAPI
FileOutputStream_newFromName(
	const char * filename);						//pointer to filename
//--

//++
//=============================================================================
// Method:	FileOutputStream_newFromFILE
// Desc:	Create a FileOutputStream object from a FILE pointer. Use with
//			XmlDocument::writeDocument() or XmlDocument::getXmlWriter()
// 
// Notes:	The passed FILE must be opened for writing.
//=============================================================================
DIRXML_EXPORT
OutputStream * IFAPI
FileOutputStream_newFromFILE(
	FILE * file);							//pointer to FILE structure
//--

//++
//=============================================================================
// Method:	FileOutputStream_destroy
// Desc:	Destroy a FileOutputStream object returned from
//			FileOutputStream_newFrom*()
// 
// Notes:
//=============================================================================
DIRXML_EXPORT
void IFAPI
FileOutputStream_destroy(
	OutputStream * outputStream);			//pointer to OutputStream returned from FileOutputStream_newFrom*()
//--

//++
//=============================================================================
// Method:	FileInputStream_newFromName
// Desc:	Create a FileInputStream object from a filename
// 
// Notes:	The passed filename will be opened using fopen(), mode "rb"
//=============================================================================
DIRXML_EXPORT
InputStream * IFAPI
FileInputStream_newFromName(
	const char * filename);					//pointer to filename
//--

//++
//=============================================================================
// Method:	FileInputStream_newFromFILE
// Desc:	Create a FileInputStream object from a FILE pointer.
// 
// Notes:	The passed FILE must be opened for reading.
//=============================================================================
DIRXML_EXPORT
InputStream * IFAPI
FileInputStream_newFromFILE(
	FILE * file);							//pointer to FILE structure
//--

//++
//=============================================================================
// Method:	FileInputStream_destroy
// Desc:	Destroy a FileInputStream object returned from
//			FileInputStream_newFrom*()
// 
// Notes:
//=============================================================================
DIRXML_EXPORT
void IFAPI
FileInputStream_destroy(
	InputStream * inputStream);				//pointer to InputStream returned from FileInputStream_newFrom*()
//--

//++
//=============================================================================
// Method:	ByteArrayOutputStream_new
// Desc:	Create a ByteArrayOutputStreamObject object with the passed initial
//			buffer size and with the passed growIncrement
// 
// Notes:
//=============================================================================
DIRXML_EXPORT
OutputStream * IFAPI
ByteArrayOutputStream_new(
	int initialSize,						//initial buffer size (0 means use default)
	int growIncrement);						//amount to grow buffer by when needed (0 means use default)
//--

//++
//=============================================================================
// Method:	ByteArrayOutputStream_getDataSize()
// Desc:	Return the size of the data in the ByteArrayOutputStream
// 
// Notes:	see ByteArrayOutputStream_getBytes()
//=============================================================================
DIRXML_EXPORT
int IFAPI
ByteArrayOutputStream_getDataSize(
	OutputStream * outputStream);			//pointer returned from ByteArrayOutputStream_new
//--

//++
//=============================================================================
// Method:	ByteArrayOutputStream_getBytes()
// Desc:	Return the data in the ByteArrayOutputStream
// 
// Notes:	The passed buffer must be at least as large as the value returned
//			from ByteArrayOutputStream_getDataSize().
//=============================================================================
DIRXML_EXPORT
int IFAPI								//amount of data returned in passed buffer
ByteArrayOutputStream_getBytes(
	OutputStream * outputStream,		//pointer returned from ByteArrayOutputStream_new
	unsigned char * buffer);			//pointer to buffer for data
//--

//++
//=============================================================================
// Method:	ByteArrayOutputStream_getBytesPointer()
// Desc:	Return pointer to the data in the ByteArrayOutputStream
// 
// Notes:	Amount of valid data pointed to by the returned pointer may be
//			obtained from from ByteArrayOutputStream_getDataSize().
//=============================================================================
DIRXML_EXPORT
const unsigned char * IFAPI				//pointer to data buffer
ByteArrayOutputStream_getBytesPointer(
	OutputStream * outputStream);		//pointer returned from ByteArrayOutputStream_new
//--	

//++
//=============================================================================
// Method:	ByteArrayOutputStream_destroy
// Desc:	Destroy a ByteArrayOutputStream object returned from
//			FileOutputStream_newFrom*()
// 
// Notes:
//=============================================================================
DIRXML_EXPORT
void IFAPI
ByteArrayOutputStream_destroy(
	OutputStream * outputStream);		//pointer to OutputStream returned from FileOutputStream_newFrom*()
//--

//++
//=============================================================================
// Method:	SAXException_new
// Desc:	Create a new SAXException instance
// 
// Notes:	This is provide as a convenience for SAX Parser interface
//			implemententations and SAX DocumentHandler/DTDHandler implementations.
//=============================================================================
DIRXML_EXPORT
SAXException * IFAPI				//pointer to SAXException interface
SAXException_new(
	const unicode * message);		//unicode message for exception
//--

//++
//=============================================================================
// Method:	SAXParseException_new
// Desc:	Create a new SAXExceptionParse instance
// 
// Notes:	This is provide as a convenience for SAX Parser interface
//			implemententations.
//=============================================================================
DIRXML_EXPORT
SAXParseException * IFAPI			//pointer to SAXParseException interface
SAXParseException_new(
	const unicode * message);		//unicode message for exception
//--

//++
//=============================================================================
// Method:	DriverFilter_new
// Desc:	Create a new DriverFilter instance based on the DOM representation
//			of an XDS driver-filter element
// 
// Notes:
//=============================================================================
DIRXML_EXPORT
DriverFilter * IFAPI								//pointer to DriverFilter interface, or 0 if driverFilterElement is invalid
DriverFilter_new(
	NAMESPACE(DOM)Element * driverFilterElement);	//pointer to XDS driver-filter element
//--

//++
//=============================================================================
// Method:	DriverFilter_destroy
// Desc:	Destroy a DriverFilter instance returned from DriverFilter_new()
// 
// Notes:
//=============================================================================
DIRXML_EXPORT
void IFAPI
DriverFilter_destroy(
	DriverFilter * driverFilter);	//DriverFilter instance returned from DriverFilter_new()
//--

//++
//=============================================================================
// Method:	Trace_new
// Desc:	Create a new Trace instance with the passed identifying label
// 
// Notes:
//=============================================================================
DIRXML_EXPORT
Trace * IFAPI						//pointer to Trace implementation
Trace_new(
	const char * identifier);		//pointer to string that will appear at start of each trace message
//--

//++
//=============================================================================
// Method:	Trace_destroy
// Desc:	Destroy a Trace instance returned from Trace_new()
// 
// Notes:
//=============================================================================
DIRXML_EXPORT
void IFAPI
Trace_destroy(
	Trace * trace);					//pointer to Trace instance returned from Trace_new
//--

//++
//=============================================================================
// Method:	DOMWriter_newToOutputStream
// Desc:	Construct an implemenation of XmlWriter that serialized a DOM
//			tree.
// 
// Notes:
//=============================================================================
DIRXML_EXPORT
XmlWriter * IFAPI					//pointer to XmlWriter implementation
DOMWriter_newToOutputStream(
	NAMESPACE(DOM)Node * node,		//root of subtree to serialize
	OutputStream * outputStream);	//OutputStream to which to serialize
//--

//++
//=============================================================================
// Method:	DOMWriter_destroy
// Desc:	Destroy an XmlWriter instance returned from
//			DOMWriter_newToOutputStream()
// 
// Notes:
//=============================================================================
DIRXML_EXPORT
void IFAPI
DOMWriter_destroy(
	XmlWriter * domWriter);			//pointer returned from DOMWriter_newToOutputStream
//--
//++
//=============================================================================
// Method:	AttributeList_new
// Desc:	Create a new attribute list
// 
// Notes:	see NativeInterface.h
//
//			The returned instance must be destroyed with a call to
//			AttributeList_destroy()

//=============================================================================
DIRXML_EXPORT
NAMESPACE(SAX)AttributeList * IFAPI
AttributeList_new(void);


//++
//=============================================================================
// Method:	AttributeList_destroy
// Desc:	Destroy a AttributeList object returned from
//			AttributeList_new()
// 
// Notes:
//=============================================================================
DIRXML_EXPORT
void IFAPI
AttributeList_destroy(
	NAMESPACE(SAX)AttributeList * attrList);			//pointer to AttributeList returned from AttributeList_new
//--

//++
//=============================================================================
// Method:	AttributeList_setAtts
// Desc:	Set attribute list
// 
// Notes:
//			attTable is a pointer to a 0-terminated array of triples of 
//			pointers. Each triple points at the name, type, and value for
//			an attribute.
//=============================================================================
DIRXML_EXPORT
void IFAPI
AttributeList_setAtts(
	NAMESPACE(SAX)AttributeList * attrList,	//pointer to AttributeList returned from AttributeList_new
	const unicode ** attTable );			//0-terminated array of UTF-16 string pointers
//--	

//++
//=============================================================================
// Method:	AttributeList_addAttribute
// Desc:	Add a single attribute to the list.
// 
// Notes:
//=============================================================================
DIRXML_EXPORT
void IFAPI
AttributeList_addAttribute(
	NAMESPACE(SAX)AttributeList * attrList,	//pointer to AttributeList returned from AttributeList_new
	const unicode * name,					//pointer to null-terminated UTF-16 attribute name
	const unicode * type,					//pointer to null-terminated UTF-16 attribute type
	const unicode * value);					//pointer to null-terminated UTF-16 attribute value
//--

//++
//=============================================================================
// Method:	AttributeList_addAttributeCDATA
// Desc:	Add a single attribute to the list.
// 
// Notes:
//			Attribute type is set to "CDATA"
//=============================================================================
DIRXML_EXPORT
void IFAPI
AttributeList_addAttributeCDATA(
	NAMESPACE(SAX)AttributeList * attrList,	//pointer to AttributeList returned from AttributeList_new
	const unicode * name,					//pointer to null-terminated UTF-16 attribute name
	const unicode * value);					//pointer to null-terminated UTF-16 attribute value
//--

//++
//=============================================================================
// Method:	AttributeList_clear
// Desc:	Clear all attributes from list.
// 
// Notes:
//
//=============================================================================
DIRXML_EXPORT
void IFAPI
AttributeList_clear(
	NAMESPACE(SAX)AttributeList * attrList);//pointer to AttributeList returned from AttributeList_new
//--

//++
//=============================================================================
// Method:	Locator_new
// Desc:	Construct a Locator object with the passed context for use with
//			SAX.
// 
// Notes:	
//
//=============================================================================
DIRXML_EXPORT
NAMESPACE(SAX)Locator * IFAPI
Locator_new(
	const unicode * publicId,			//unicode public id string (may be 0)
	const unicode * systemId,			//unicode system id string (may be 0)
	int lineNumber,						//line number (should be -1 if invalid)
	int columnNumber);					//column number (should be -1 if invalid)
//--	

//++
//=============================================================================
// Method:	Locator_destroy
// Desc:	Destroy the object returned from Locator_new()
//			SAX.
// 
// Notes:	
//
//=============================================================================
DIRXML_EXPORT
void IFAPI
Locator_destroy(
	NAMESPACE(SAX)Locator * locator);	//pointer returned from Locator_new()
//--	


#if	defined(__cplusplus)
}	//close extern "C"
#endif

#endif	//#ifndef _INTERFACEFACTORY_H_
