/******************************************************************************
* Name: NdsDtd.h
* Description:	Collection of DirXML XML tags and value strings, plus
*				some helper functions.
* Tabs: 4
*
* Copyright (C) 2000 Novell, Inc., All Rights Reserved
*
* %version:   2.1.2.1.2 %
* %created_by:  bthurgoo %
* %date_modified:  Fri Jun  7 11:17:00 2002 %
******************************************************************************/
#ifndef	_NDSDTD_H_
#define	_NDSDTD_H_
#include	"dom.h"
#include	"NativeInterface.h"

#if	defined(_WIN32)
#define NDAPI	__stdcall
#else
#define	NDAPI
#endif

typedef	unsigned short unicode;

//define constants for NdsDtd_addStatus()
#if	defined(__cplusplus)
const int STATUS_LEVEL_FATAL = 0;
const int STATUS_LEVEL_ERROR = 1;
const int STATUS_LEVEL_WARNING = 2;
const int STATUS_LEVEL_SUCCESS = 3;
const int STATUS_LEVEL_RETRY = 4;
#else
#define	STATUS_LEVEL_FATAL	0
#define	STATUS_LEVEL_ERROR	1
#define	STATUS_LEVEL_WARNING	2
#define	STATUS_LEVEL_SUCCESS	3
#define	STATUS_LEVEL_RETRY		4
#endif

//NOTE: modifications to this structure must be mirrored exactly in the
//definition of the const structure in NdsDtd.c
struct NdsDtd
{
//element tags
	const unicode	* TAG_NDS;					//<nds>
	const unicode	* TAG_SOURCE;				//<source>
	const unicode	* TAG_INPUT;				//<input>
	const unicode	* TAG_OUTPUT;				//<output>
	const unicode	* TAG_PRODUCT;				//<product>
	const unicode	* TAG_CONTACT;				//<contact>
	const unicode	* TAG_ADD;					//<add>
	const unicode	* TAG_MODIFY;				//<modify>
	const unicode	* TAG_DELETE;				//<delete>
	const unicode	* TAG_RENAME;				//<rename>
	const unicode	* TAG_MOVE;					//<move>
	const unicode	* TAG_QUERY;				//<query>
	const unicode	* TAG_QUERY_SCHEMA;			//<query-schema>
	const unicode	* TAG_ADD_ASSOCIATION;		//<add-association>
	const unicode	* TAG_MODIFY_ASSOCIATION;	//<modify-association>
	const unicode	* TAG_REMOVE_ASSOCIATION;	//<remove-association>
	const unicode	* TAG_INIT_PARAMS;			//<init-params>
	const unicode	* TAG_STATUS;				//<status>
	const unicode	* TAG_CHECK_PASSWORD;		//<check-password>
	const unicode	* TAG_INSTANCE;				//<instance>
	const unicode	* TAG_SCHEMA_DEF;			//<schema-def>
	const unicode	* TAG_VALUE;				//<value>
	const unicode	* TAG_COMPONENT;			//<component>
	const unicode	* TAG_ASSOCIATION;			//<association>
	const unicode	* TAG_PARENT;				//<parent>
	const unicode	* TAG_SEARCH_CLASS;			//<search-class>
	const unicode	* TAG_SEARCH_ATTR;			//<search-attr>
	const unicode	* TAG_READ_ATTR;			//<read-attr>
	const unicode	* TAG_READ_PARENT;			//<read-parent>
	const unicode	* TAG_ADD_ATTR;				//<add-attr>
	const unicode	* TAG_PASSWORD;				//<password>
	const unicode	* TAG_MODIFY_ATTR;			//<modify-attr>
	const unicode	* TAG_REMOVE_VALUE;			//<remove-value>
	const unicode	* TAG_REMOVE_ALL_VALUES;	//<remove-all-values>
	const unicode	* TAG_ADD_VALUE;			//<add-value>
	const unicode	* TAG_NEW_NAME;				//<new-name>
	const unicode	* TAG_ATTR;					//<attr>
	const unicode	* TAG_AUTHENTICATION_INFO;	//<authentication-info>
	const unicode	* TAG_DRIVER_FILTER;		//<driver-filter>
	const unicode	* TAG_DRIVER_OPTIONS;		//<driver-options>
	const unicode	* TAG_SUBSCRIBER_OPTIONS;	//<subscriber-options>
	const unicode	* TAG_PUBLISHER_OPTIONS;	//<publisher-options>
	const unicode	* TAG_DRIVER_STATE;			//<driver-state>
	const unicode	* TAG_SUBSCRIBER_STATE;		//<subscriber-state>
	const unicode	* TAG_PUBLISHER_STATE;		//<publisher-state>
	const unicode	* TAG_SERVER;				//<server>
	const unicode	* TAG_USER;					//<user>
	const unicode	* TAG_ALLOW_CLASS;			//<allow-class>
	const unicode	* TAG_ALLOW_ATTR;			//<allow-attr>
	const unicode	* TAG_DRIVER_CONFIG;		//<driver-config>
	const unicode	* TAG_CONFIG_OBJECT;		//<config-object>
	const unicode	* TAG_CLASS_DEF;			//<class-def>
	const unicode	* TAG_ATTR_DEF;				//<attr-def>

//attribute names
	const unicode	* ATTR_NDSVERSION;			//ndsversion
	const unicode	* ATTR_DTDVERSION;			//dtdversion
	const unicode	* ATTR_VERSION;				//version
	const unicode	* ATTR_ASN1ID;				//asn1id
	const unicode	* ATTR_TYPE;				//type
	const unicode	* ATTR_ASSOCIATION_REF;		//association-ref
	const unicode	* ATTR_NAMING;				//naming
	const unicode	* ATTR_TIMESTAMP;			//timestamp
	const unicode	* ATTR_NAME;				//name
	const unicode	* ATTR_STATE;				//state
	const unicode	* ATTR_SRC_DN;				//src-dn
	const unicode	* ATTR_SRC_ENTRY_ID;		//src-entry-id
	const unicode	* ATTR_DEST_DN;				//dest-dn
	const unicode	* ATTR_DEST_ENTRY_ID;		//dest-entry-id
	const unicode	* ATTR_CLASS_NAME;			//class-name
	const unicode	* ATTR_SCOPE;				//scope
	const unicode	* ATTR_EVENT_ID;			//event-id
	const unicode	* ATTR_ATTR_NAME;			//attr-name
	const unicode	* ATTR_TEMPLATE_DN;			//template-dn
	const unicode	* ATTR_OLD_SRC_DN;			//src-old-src-dn
	const unicode	* ATTR_REMOVE_OLD_NAME;		//remove-old-name
	const unicode	* ATTR_LEVEL;				//level
	const unicode	* ATTR_DISPLAY_NAME;		//display-name
	const unicode	* ATTR_HIERARCHICAL;		//hierarchical
	const unicode	* ATTR_APPLICATION_NAME;	//application-name
	const unicode	* ATTR_CONTAINER;			//container
	const unicode	* ATTR_REQUIRED;			//required
	const unicode	* ATTR_MULTI_VALUED;		//multi-valued
	const unicode	* ATTR_CASE_SENSITIVE;		//case-sensitive
	const unicode	* ATTR_READ_ONLY;			//read-only

//attribute values
	const unicode	* VAL_NOT_ASSOCIATED;		//"not-associated"
	const unicode	* VAL_ASSOCIATED;			//"associated"
	const unicode	* VAL_DISABLED;				//"disabled"
	const unicode	* VAL_MIGRATE;				//"migrate"
	const unicode	* VAL_PENDING;				//"pending"
	const unicode	* VAL_MANUAL;				//"manual"
	const unicode	* VAL_ENTRY;				//"entry"
	const unicode	* VAL_SUBORDINATES;			//"subordinates"
	const unicode	* VAL_SUBTREE;				//"subtree"
	const unicode	* VAL_FATAL;				//"fatal"
	const unicode	* VAL_ERROR;				//"error"
	const unicode	* VAL_WARNING;				//"warning"
	const unicode	* VAL_SUCCESS;				//"success"
	const unicode	* VAL_RETRY;				//"retry"
	const unicode	* VAL_STRING;				//"string"
	const unicode	* VAL_TELENUMBER;			//"teleNumber"
	const unicode	* VAL_INT;					//"int"
	const unicode	* VAL_STATE;				//"state"
	const unicode	* VAL_COUNTER;				//"counter"
	const unicode	* VAL_DN;					//"dn"
	const unicode	* VAL_INTERVAL;				//"interval"
	const unicode	* VAL_OCTET;				//"octet"
	const unicode	* VAL_TIME;					//"time"
	const unicode	* VAL_STRUCTURED;			//"structured"
	const unicode	* VAL_DEFAULT;				//"default"
	const unicode	* VAL_XML;					//"xml"
	const unicode	* VAL_TRUE;					//"true"
	const unicode	* VAL_FALSE;				//"false"
	const unicode	* VAL_DOT;					//"dot"
	const unicode	* VAL_QUALIFIED_DOT;		//"qualified-dot"
	const unicode	* VAL_SLASH;				//"slash"
	const unicode	* VAL_QUALIFIED_SLASH;		//"qualified-slash"
	const unicode	* VAL_LDAP;					//"ldap"
	const unicode	* VAL_SUBSCRIBER;			//"subscriber"
	const unicode	* VAL_PUBLISHER;			//"publisher"
	const unicode	* VAL_CURRENT_NDS_VERSION;	//"8.6"
	const unicode	* VAL_CURRENT_DTD_VERSION;	//"1.1"

	const unicode	* VAL_DRIVER_IDENT_CLASS;	//"__driver_identification_class__"
	const unicode	* VAL_DRIVER_ID;			//"driver-id"
	const unicode	* VAL_DRIVER_VERSION;		//"driver-version"
	const unicode	* VAL_MIN_ACTIVATION_VERSION;	//"min-activation-version"

	//stuff added after DirXML 1.1
	const unicode   * TAG_MODULE;				//<module>
	const unicode   * TAG_CODE;					//<code>
	const unicode   * TAG_DESCRIPTION;			//<description>
	const unicode   * TAG_OBJECT_DN;			//<object-dn>
	const unicode   * TAG_APPLICATION;			//<application>
};

typedef struct NdsDtd NdsDtd;

#if	defined(__cplusplus)
extern "C"
{
#endif

//++
//=============================================================================
// Method:	NdsDtd_getStrings
// Desc:	Return a pointer to an NdsDtd structure for access to XML string
//			values
// 
// Notes:
//=============================================================================
DIRXML_EXPORT
const NdsDtd * NDAPI	//read-only pointer to NdsDtd structure
NdsDtd_getStrings();
//--

//++
//=============================================================================
// Method:	NdsDtd_newInputDocument
// Desc:	Create a new XML document of the form:
//
//				&lt;nds ndsversion="8.6" dtdversion="1.1">&lt;input/>&lt;/nds>
//
//			and return a pointer to the &lt;input> element.
// 
// Notes:	The caller is responsible for destroying the returned document.
//			The document can be obtained by calling getOwnerDocument() on the
//			returned element.
//=============================================================================
DIRXML_EXPORT
NAMESPACE(DOM)Element * NDAPI			//pointer to the &lt;input> element in the new document (0 if error)
NdsDtd_newInputDocument(void);
//--

//++
//=============================================================================
// Method:	NdsDtd_newOutputDocument
// Desc:	Create a new XML document of the form:
//
//				&lt;nds ndsversion="8.6" dtdversion="1.1">&lt;output/>&lt;/nds>
//
//			and return a pointer to the &lt;output> element.
// 
// Notes:	The caller is responsible for destroying the returned document.
//			The document can be obtained by calling getOwnerDocument() on the
//			returned element.
//=============================================================================
DIRXML_EXPORT
NAMESPACE(DOM)Element * NDAPI			//pointer to the &lt;output> element in the new document (0 if error)
NdsDtd_newOutputDocument(void);
//--

//++
//=============================================================================
// Method:	NdsDtd_addStatus
// Desc:	Add a <status> element to an input or output document.
//
//			The status element will have the level attribute set based on the
//			statusLevel parameter, and may have an eventId attribute and/or
//			a text node child with any message passed.
// 
// Notes:
//=============================================================================
DIRXML_EXPORT
NAMESPACE(DOM)Element * NDAPI			//pointer to the new <status> element (0 if error)
NdsDtd_addStatus(
NAMESPACE(DOM)Element * statusParent,	//pointer to the <input> or <output> element to which the <status> element is to be added
int statusLevel,						//STATUS_LEVEL_FATAL, STATUS_LEVEL_ERROR, STATUS_LEVEL_WARNING, STATUS_LEVEL_SUCCESS, or STATUS_LEVEL_RETRY
const unicode * message,				//pointer to null-terminated message string (may be 0)
const unicode * eventId);				//pointer to null-terminated event id string (may be 0)
//--

#if	defined(__cplusplus)
}	//close extern "C"
#endif


#endif	//#ifndef	_NDSDTD_H_
