/*************************************************************************
Copyright  1999-2002 Novell, Inc. All Rights Reserved. 

THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND 
TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE
AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS
THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS
TO DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S
SAMPLE CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION
RIGHTS TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT
OF DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR
DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

***************************************************************************/
#ifndef _OUTPUTSTREAM_H_
#define	_OUTPUTSTREAM_H_

#include	"define_interface.h"

//++
/*****************************************************************
Interface: OutputStream
Desc:
	An interface for writing bytes to a byte sink.

Notes:

*****************************************************************/
INTERFACE(OutputStream)
//--

	//++
	//=========================================================================
	// Method:	close
	// Desc:	Flush any unwritten bytes and close the stream	
	// 
	// Notes:	
	//=========================================================================
	METHOD(OutputStream, close, void)
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	flush
	// Desc:	Flush any unwritten bytes to the stream
	// 
	// Notes:	
	//=========================================================================
	METHOD(OutputStream, flush, void)
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	write
	// Desc:	Write bytes to the stream
	// 
	// Notes:	
	//=========================================================================
	METHOD(OutputStream, write, int)				//number of bytes actually written
		METHOD_PARM1(const unsigned char * bytes)	//array of bytes
		METHOD_PARM(int length)						//length of byte array
	END_METHOD
	//--

#if	defined(__cplusplus)
	//++
	//=========================================================================
	// Method:	write
	// Desc:	Write a single byte to the stream
	// 
	// Notes:	
	//		For C, this method is called writeByte
	//=========================================================================
	METHOD(OutputStream, write, int)				//number of bytes written (0 or 1)
		METHOD_PARM1(unsigned char byte)			//the byte to write
	END_METHOD
	//--
#else
	METHOD(OutputStream, writeByte, int)			//number of bytes written (0 or 1)
		METHOD_PARM1(unsigned char byte)			//the byte to write
	END_METHOD
#endif

END_INTERFACE(OutputStream)

#if	!defined(__cplusplus)

#define	OutputStream_close(_this)\
	(*_this->vTbl->close)(_this)

#define	OutputStream_flush(_this)\
	(*_this->vTbl->flush)(_this)

#define	OutputStream_write(_this,bytes,length)\
	(*_this->vTbl->write)(_this,bytes,length)

#define	OutputStream_writeByte(_this,byte)\
	(*_this->vTbl->writeByte)(_this,byte)

#endif


#endif	//#ifndef _OUTPUTSTREAM_H_
