/*************************************************************************
Copyright  1999-2002 Novell, Inc. All Rights Reserved. 

THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND 
TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE
AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS
THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS
TO DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S
SAMPLE CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION
RIGHTS TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT
OF DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR
DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

***************************************************************************/
/*******************************************************************
* Name: Trace.h
* Description: Trace facility for native DirXML drivers
* Tabs: 4
*******************************************************************/


#ifndef _TRACE_H_
#define	_TRACE_H_

#include	"NativeInterface.h"

#if	defined(_WIN32)
#define TRCAPI	__stdcall
#else
#define	TRCAPI
#endif

using namespace DOM;


// Constant corresponding to no trace messages level
const int	NO_TRACE		=	0;

//Constant corresponding to trace level at or above which trace messages
//are displayed.
const int	DEFAULT_TRACE	=	1;

//Constant corresponding to trace level at or above which XML documents
//are displayed
const int	XML_TRACE		=	2;

//++
/*****************************************************************
Interface: Trace
Desc:
	An interface for writing messages to the DirXML trace facility

Notes:

*****************************************************************/
INTERFACE(Trace)
//--
	//++
	//=========================================================================
	// Method:	getTraceLevel
	// Desc:	Return the current trace level
	// 
	// Notes:	
	//=========================================================================
	METHOD(Trace, getTraceLevel, int)
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	pushIndent
	// Desc:	Indent messages <code>tabCount</code> tabs. This will indent
	//			messages after the <code>identifier</code> string is output.
	// 
	// Notes:	
	//=========================================================================
	METHOD(Trace, pushIndent, void)
		METHOD_PARM1(int tabCount)			//Number of tabs to indent message.
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	popIndent
	// Desc:	Restore indent state after a <code>pushIndent()</code> call.
	// 
	// Notes:	
	//=========================================================================
	METHOD(Trace, popIndent, void)
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	resetIndent
	// Desc:	Reset the indent level to 0 regardless of any pushed levels.
	// 
	// Notes:	
	//=========================================================================
	METHOD(Trace, resetIndent, void)
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	trace
	// Desc:	Display a trace message if current trace level is greater than
	//			or equal to the <code>DEFAULT_TRACE</code> level.
	// 
	// Notes:	
	//=========================================================================
	METHOD(Trace, trace, void)
		METHOD_PARM1(const unicode * message)			//The message to display
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	trace
	// Desc:	Display a trace message if current trace level is greater than
	//			passed level
	// 
	// Notes:	
	//=========================================================================
	METHOD(Trace, trace, void)
		METHOD_PARM1(const unicode * message)			//The message to display
		METHOD_PARM(int level)							//trace level for this message
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	trace
	// Desc:	Display a trace message if current trace level is greater than
	//			or equal to the <code>DEFAULT_TRACE</code> level.
	// 
	// Notes:	
	//=========================================================================
	METHOD(Trace, trace, void)
		METHOD_PARM1(const char * message)				//The message to display
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	trace
	// Desc:	Display a trace message if current trace level is greater than
	//			passed level
	// 
	// Notes:	
	//=========================================================================
	METHOD(Trace, trace, void)
		METHOD_PARM1(const char * message)				//The message to display
		METHOD_PARM(int level)							//trace level for this message
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	trace
	// Desc:	Display an XML document if current trace level is
	//			<code>XML_TRACE</code> or greater
	// 
	// Notes:	
	//=========================================================================
	METHOD(Trace, trace, void)
		METHOD_PARM1(Document * document)				//The XML document to display
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	trace
	// Desc:	Display an XML document if current trace level is greater than
	//			or equal to the passed level.
	// 
	// Notes:	
	//=========================================================================
	METHOD(Trace, trace, void)
		METHOD_PARM1(Document * document)				//The XML document to display
		METHOD_PARM(int level)							//The trace level at or above which to display
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	trace
	// Desc:	Display an XML document if current trace level is
	//			<code>XML_TRACE</code> or greater
	// 
	// Notes:	
	//=========================================================================
	METHOD(Trace, trace, void)
		METHOD_PARM1(XmlDocument * document)				//The XML document to display
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	trace
	// Desc:	Display an XML document if current trace level is greater than
	//			or equal to the passed level.
	// 
	// Notes:	
	//=========================================================================
	METHOD(Trace, trace, void)
		METHOD_PARM1(XmlDocument * document)			//The XML document to display
		METHOD_PARM(int level)							//The trace level at or above which to display
	END_METHOD
	//--

END_INTERFACE(Trace)


#endif	//#ifndef _TRACE_H_
