/*************************************************************************
Copyright  1999-2002 Novell, Inc. All Rights Reserved. 

THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND 
TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE
AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS
THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS
TO DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S
SAMPLE CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION
RIGHTS TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT
OF DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR
DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

***************************************************************************/
/*******************************************************************
* Name: UTFConverter.h
* Description: collection of functions to convert between UTF-8 and
* UTF-16 character strings
* Tabs: 4
*******************************************************************/
#ifndef _UTFCONVERTER_H_
#define	_UTFCONVERTER_H_

#include	"NativeInterface.h"
#include	<stddef.h>

#if	defined(_WIN32)
#define IFAPI	__stdcall
#else
#define	IFAPI
#endif

#if defined(__cplusplus)
extern "C" {
#endif

//++
//=============================================================================
// Method:	UTFConverter_16to8
// Desc:	Convert a 0-terminated UTF-16 string to a 0-terminated UTF-8 string
// 
// Notes:
//			The returned string must be freed via a call to UTFConverter_free()
//=============================================================================
DIRXML_EXPORT
char * IFAPI						//pointer to UTF-8 string (null if error)
UTFConverter_16to8(
const unicode * utf16);				//pointer to 0-terminated UTF-16 string
//--

//++
//=============================================================================
// Method:	UTFConverter_8to16
// Desc:	Convert a 0-terminated UTF-8 string to a 0-terminated UTF-16 string
// 
// Notes:
//			The returned string must be freed via a call to UTFConverter_free()
//=============================================================================
DIRXML_EXPORT
unicode * IFAPI						//pointer to UTF-16 string (null if error)
UTFConverter_8to16(
const char * utf8);					//pointer to 0-terminated UTF-8 string
//--

//++
//=============================================================================
// Method:	UTFConverter_sizeTo8
// Desc:	Convert a size_t value to string of null-terminated UTF-8 bytes.
// 
// Notes:
//			The returned string must be freed via a call to UTFConverter_free()
//
//			This can only handle sizes up to 32 bits.
//=============================================================================
DIRXML_EXPORT
size_t IFAPI						//count of bytes placed into buffer
UTFConverter_sizeTo8(
char * buffer,						//buffer, at least 6 bytes, into which UTF-8 bytes are placed
size_t size);						//size_t value to convert
//--

//++
//=============================================================================
// Method:	UTFConverter_sizeFrom8
// Desc:	Convert a string of UTF-8 bytes to a size_t value.
// 
// Notes:
//			This can only handle sizes up to 32 bits.
//=============================================================================
DIRXML_EXPORT
size_t IFAPI						//size_t value from UTF-8 value
UTFConverter_sizeFrom8(
const char ** utf8Size);			//pointer to UTF-8 bytes, gets pointer past
									//those bytes that were read.
//--

//++
//=============================================================================
// Method:	UTFConverter_free
// Desc:	Free a string returned from UTFConverter_16to8() or 
//			UTF_Converter_8to16()
// 
// Notes:
//=============================================================================
DIRXML_EXPORT
void IFAPI
UTFConverter_free(
void * encodedData);				//pointer to string returned converter function
//--

#if defined(__cplusplus)
}
#endif

#endif	//#ifndef _BASE64CODEC_H_
