/*************************************************************************
Copyright  1999-2002 Novell, Inc. All Rights Reserved. 

THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND 
TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE
AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS
THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS
TO DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S
SAMPLE CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION
RIGHTS TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT
OF DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR
DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

***************************************************************************/
/*******************************************************************
* Name: XdsUtil.h
* Description: Utility functions for dealing with XDS/XML
* Tabs: 4
*******************************************************************/
#ifndef _XDSUTIL_H_
#define	_XDSUTIL_H_
#include	"dom.h"
#include	"NativeInterface.h"

#if	defined(_WIN32)
#define XUAPI	__stdcall
#else
#define	XUAPI
#endif

#if	defined(__cplusplus)
extern "C"
{
#endif

//++
//=============================================================================
// Method:	XdsUtil_getNodeText
// Desc:	Get the text value of a node, as defined by XPath
// 
// Notes:
//			If *sizeNeeded > bufferSize then not all of the text value was
//			copied into the buffer. Calling with bufferSize == 0 will return
//			the size needed in sizeNeeded. A subsequent call can then be made
//			with a large-enough buffer.
//=============================================================================
DIRXML_EXPORT
const unicode * XUAPI				//pointer to buffer
XdsUtil_getNodeText(
	NAMESPACE(DOM)Node * node,		//node, whose text value is to be returned
	unicode * buffer,				//pointer to buffer in which to return text
	int bufferSize,					//size of buffer
	int * sizeNeeded);				//pointer to int which will receive sized needed for text value
//--

//++
//=============================================================================
// Method:	XdsUtil_cloneSubtree
// Desc:	Make a copy of a DOM subtree, returning the root of the subtree
//			copy.
//
// 
// Notes:
//=============================================================================
DIRXML_EXPORT
Node * XUAPI						//pointer to root of subtree copy	
XdsUtil_cloneSubtree(
	Document * targetDoc,			//document to use for the node factory for the copy
	Node * sourceRoot);				//root of the subtree to copy
//--

//++
//=============================================================================
// Method:	XdsUtil_graftSubtree
// Desc:	Graft a cloned subtree, possibly into another document
//
// 
// Notes:
//=============================================================================
DIRXML_EXPORT
void XUAPI
XdsUtil_graftSubtree(
	NAMESPACE(DOM)Node * parent,		//The target parent, under which the cloned subtree is to be grafted
	NAMESPACE(DOM)Node * sourceRoot);	//The root of the subtree to clone	
//--

//++
//=============================================================================
// Method:	XdsUtil_cloneDocument
// Desc:	Creates  clone of a document
//
// 
// Notes:
//			Only clones document tree structure
//=============================================================================
DIRXML_EXPORT
NAMESPACE(DOM)Document * XUAPI			//pointer to copy of Document
XdsUtil_cloneDocument(
	NAMESPACE(DOM)Document * doc);		//Document to copy
//--

#if	defined(__cplusplus)
}	//close extern "C"
#endif

#endif	//#ifndef _XDSUTIL_H_
