/*******************************************************************
* Name: XdsUtil.h
* Description: Utility functions for dealing with XDS/XML
* Tabs: 4
*
* Copyright (C) 2000 Novell, Inc., All Rights Reserved
* COMPANY CONFIDENTIAL -- NOT FOR DISTRIBUTION
*
* %version:   3 %
* %created_by:   pblancha %
* %date_modified:  Mon Jan  7 16:33:21 2002 %
*******************************************************************/
/*******************************************************************
* Name: XmlWriter.h
* Description: Interface for controlling XML serialization
* Tabs: 4
*******************************************************************/
#ifndef _XMLWRITER_H_
#define	_XMLWRITER_H_

#include	"define_interface.h"
#include	"dom.h"

//++
/*****************************************************************
Interface: XmlWriter
Desc:
	This interface allows control over the serialization of an XML
	document.

Notes: 

*****************************************************************/
INTERFACE(XmlWriter)
//--

	//++
	//=========================================================================
	// Method:	write
	// Desc:	Serialize the XML data associated with the writer
	// 
	// Notes:	
	//=========================================================================
	METHOD(XmlWriter, write, int)	//non-zero return indicates success
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	getWriteDeclaration
	// Desc:	Return non-zero if the XmlWriter will output an XML declaration
	// 
	// Notes:	
	//=========================================================================
	METHOD(XmlWriter, getWriteDeclaration, int)	//non-zero if XML decl will be output
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	setWriteDeclaration
	// Desc:	Set if XmlWriter should output an XML declaration
	// 
	// Notes:	
	//=========================================================================
	METHOD(XmlWriter, setWriteDeclaration, void)
		METHOD_PARM1(int writeDeclaration)		//non-zero if XML decl should be output
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	getEncoding
	// Desc:	Return string with name of character encoding to use, if available
	// 
	// Notes:	
	//=========================================================================
	METHOD(XmlWriter, getEncoding, const unicode *)//name of encoding
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	setEncoding
	// Desc:	Set the name of the character encoding to use, if available
	// 
	// Notes:	
	//=========================================================================
	METHOD(XmlWriter, setEncoding, void)
		METHOD_PARM1(const unicode * encoding)
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	getEndian
	// Desc:	Return non-zero if big-endian (Motorola) byte-ordering will
	//			be used with encodings for which it matters (e.g., UTF-16). 
	//			A return of zero means little-endian (Intel) ordering.
	// 
	// Notes:	
	//=========================================================================
	METHOD(XmlWriter, getEndian, int)			//non-zero if big-endian
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	setEndian
	// Desc:	Set the if big-endian (Motorola) byte-ordering or little-endian
	//			(Intel) byte-ordering should be used for encodings for which
	//			it matters (e.g., UTF-16)
	// 
	// Notes:	
	//=========================================================================
	METHOD(XmlWriter, setEndian, void)
		METHOD_PARM1(int endian)				//non-zero for big-endian
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	getIndent
	// Desc:	Return non-zero if extra whitespace will be output for
	//			readability
	// 
	// Notes:	
	//=========================================================================
	METHOD(XmlWriter, getIndent, int)	//non-zero if extra whitespace will be output
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	setIndent
	// Desc:	Set if extra whitespace may be output for readability
	// 
	// Notes:	
	//=========================================================================
	METHOD(XmlWriter, setIndent, void)
		METHOD_PARM1(int indent)		//non-zero if extra whitespace may be output
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	getStandalone
	// Desc:	Return non-zero if a "standalone=yes" declaration will be output
	//			in the XML decl, if one is output
	// 
	// Notes:	
	//=========================================================================
	METHOD(XmlWriter, getStandalone, int)
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	setStandalone
	// Desc:	Set if a "standalone=yes" declaration should be output in any
	//			XML decl that is output.
	// 
	// Notes:	
	//=========================================================================
	METHOD(XmlWriter, setStandalone, void)
		METHOD_PARM1(int standalone)	//non-zero for a "standalone=yes" decl
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	getDoctypePublic
	// Desc:	Return the public id to use for the DOCTYPE, if any
	// 
	// Notes:	
	//=========================================================================
	METHOD(XmlWriter, getDoctypePublic, const unicode *)	//0, or the DOCTYPE public id
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	setDoctypePublic
	// Desc:	Set the public id to use for the DOCTYPE. 
	// 
	// Notes:	
	//			The public id will only be used if there is also a system id.
	//=========================================================================
	METHOD(XmlWriter, setDoctypePublic, void)
		METHOD_PARM1(const unicode * doctypePublic)	//public id for the DOCTYPE (may be 0)
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	getDoctypeSystem
	// Desc:	Return the system id to use for the DOCTYPE, if any
	// 
	// Notes:
	//			If the system id is non-null and non-empty, then a DOCTYPE
	//			declaration will be output	
	//=========================================================================
	METHOD(XmlWriter, getDoctypeSystem, const unicode *)	//0, or the DOCTYPE system id
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	setDoctypeSystem
	// Desc:	Set the system id to use for the DOCTYPE.
	// 
	// Notes:	
	//			If the system id is non-null and non-empty, then a DOCTYPE
	//			declaration will be output	
	//=========================================================================
	METHOD(XmlWriter, setDoctypeSystem, void)
		METHOD_PARM1(const unicode * doctypeSystem)	//system id for the DOCTYPE (may be 0)
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	getDisableTextEscaping
	// Desc:	Return non-zero if XML text escaping is disabled for this
	//			XmlWriter.
	// 
	// Notes:	
	//			Disabling text escaping means that no character references or
	//			entity references will be output for text nodes.
	//=========================================================================
	METHOD(XmlWriter, getDisableTextEscaping, int)
	END_METHOD
	//--

	//++
	//=========================================================================
	// Method:	setDisableTextEscaping
	// Desc:	Set if XML text escaping should be disabled for this XmlWriter
	// 
	// Notes:	
	//			Disabling text escaping means that no character references or
	//			entity references will be output for text nodes.
	//=========================================================================
	METHOD(XmlWriter, setDisableTextEscaping, void)
		METHOD_PARM1(int disableTextEscaping)
	END_METHOD
	//--

END_INTERFACE(XmlWriter)

#if	!defined(__cplusplus)

#define	XmlWriter_write(_this)\
	(*_this->vTbl->write)(_this)

#define	XmlWriter_getWriteDeclaration(_this)\
	(*_this->vTbl->getWriteDeclaration)(_this)

#define	XmlWriter_setWriteDeclaration(_this,decl)\
	(*_this->vTbl->setWriteDeclaration)(_this,decl)

#define	XmlWriter_getEncoding(_this)\
	(*_this->vTbl->getEncoding)(_this)

#define	XmlWriter_setEncoding(_this,enc)\
	(*_this->vTbl->setEncoding)(_this,enc)

#define	XmlWriter_getEndian(_this)\
	(*_this->vTbl->getEndian)(_this)

#define	XmlWriter_setEndian(_this,end)\
	(*_this->vTbl->setEndian)(_this,end)

#define	XmlWriter_getIndent(_this)\
	(*_this->vTbl->getIndent)(_this)

#define	XmlWriter_setIndent(_this,ind)\
	(*_this->vTbl->setIndent)(_this,ind)

#define	XmlWriter_getStandalone(_this)\
	(*_this->vTbl->getStandalone)(_this)

#define	XmlWriter_setStandalone(_this,sa)\
	(*_this->vTbl->setStandalone)(_this,sa)

#define	XmlWriter_getDoctypePublic(_this)\
	(*_this->vTbl->getDoctypePublic)(_this)

#define	XmlWriter_setDoctypePublic(_this,dtp)\
	(*_this->vTbl->setDoctypePublic)(_this,dtp)

#define	XmlWriter_getDoctypeSystem(_this)\
	(*_this->vTbl->getDoctypeSystem)(_this)

#define	XmlWriter_setDoctypeSystem(_this,dts)\
	(*_this->vTbl->setDoctypeSystem)(_this,dts)

#define	XmlWriter_getDisableTextEscaping(_this)\
	(*_this->vTbl->getDisableTextEscaping)(_this)

#define	XmlWriter_setDisableTextEscaping(_this,dte)\
	(*_this->vTbl->setDisableTextEscaping)(_this,dte)


#endif	//#if	!(defined(__cplusplus)

#endif	//#ifndef _XMLWRITER_H_
