/*************************************************************************
Copyright  1999-2002 Novell, Inc. All Rights Reserved. 

THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND 
TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE
AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS
THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS
TO DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S
SAMPLE CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION
RIGHTS TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT
OF DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR
DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

***************************************************************************/
/*******************************************************************
* Name: CSkeletonDriver.h
* Description: Platform independent code for CSkeletonDriver
* DriverShim implementation
* Tabs: 4
*******************************************************************/


#ifndef _CSKELETONDRIVER_H_
#define _CSKELETONDRIVER_H_

#include	"NativeInterface.h"
#include	"CommonImpl.hpp"

// forward declarations
class SkeletonPublisher;
class SkeletonSubscriber;

//++
/*****************************************************************
Class: CSkeletonDriver
Desc:
	A basic skeleton for implementing a DriverShim instance.

	The interface DriverShim in NativeInterface.h defines a top-level
	interface for starting and stopping an application shim.

	A DriverShim is created by an exported "CreateDriver" method from
	the containing, .dll, .nlm, or shared library.

	Note that the skeleton driver makes no use of .ini files or any
	information outside of that	supplied through the initialization
	data supplied to the shim init() methods. In general it is
	inappropriate for a driver to store configuration information
	outside of NDS where it cannot be remotely configured using
	ConsoleOne or other remote configuration utility.

	In addition it is unwise to have static mutable class data, since
	that prevents multiple instances of the driver from functioning
	independently.

Notes:

*****************************************************************/
//--
class CSkeletonDriver
	: public DriverShim
{
public:
///////////////////////////////////////////////////////////////////////////////
//	Methods implementing DriverShim
///////////////////////////////////////////////////////////////////////////////
	//macro required by DirXML interface definition (see define_interface.h)
	DECLARE_IMPL(DriverShim);
	//methods
	XmlDocument * METHOD_CALL init(XmlDocument * shimParameters);
	XmlDocument * METHOD_CALL shutdown(XmlDocument * reason);
	SubscriptionShim * METHOD_CALL getSubscriptionShim(void);
	PublicationShim * METHOD_CALL getPublicationShim(void);
	XmlDocument * METHOD_CALL getSchema(XmlDocument * initParameters);
	void METHOD_CALL destroy(void);

	//implementation detail
	CSkeletonDriver(void);
	~CSkeletonDriver();

private:
	//use CommonImpl rather than deriving from to avoid multiple inheritance
	CommonImpl	common;
	//shims that do all the real work
	SkeletonSubscriber	* subscriptionShim;
	SkeletonPublisher	* publicationShim;
	//stored copy of authentication into passed to init() - this copy
	//is shared by the sub and pub shims as well.
	CommonImpl::AuthenticationParams	* authParams;
	//other init parameters specific to the driver shim
	CommonImpl::ShimParams				* params;

	static const CommonImpl::ShimParamDesc DRIVER_PARAMS[];
};

#endif //#define _CSKELETONDRIVER_H_
