/*************************************************************************
Copyright  1999-2002 Novell, Inc. All Rights Reserved. 

THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND 
TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE
AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS
THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS
TO DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S
SAMPLE CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION
RIGHTS TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT
OF DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR
DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

***************************************************************************/
/*******************************************************************
* Name: SkeletonPublisher.h
* Description: Platform independent code for CSkeletonDriver
* PublicationShim implementation
* Tabs: 4
*******************************************************************/

#if !defined(_SKELETONPUBLISHER_H_)
#define	_SKELETONPUBLISHER_H_

#include	"NativeInterface.h"
#include	"DriverFilter.h"
#include	"CommonImpl.hpp"

class CSkeletonDriver;

typedef	void *	SEMAPHORE_HANDLE;

//++
/*****************************************************************
Class: SkeletonPublisher
Desc:
	A basic skeleton for implementing a PublicationShim.

	The PublicationShim is an interface used to start the application
	driver publication process.

	A PublicationShim will almost always also implement
	XmlQueryProcessor but it could also delegate it to another object.

	Note that the publisher init() and start() methods are called on
	a thread separate from the thread used for calling the DriverShim
	and SubscriptionShim methods.

Notes:

*****************************************************************/
//--
class SkeletonPublisher
	: public PublicationShim, public XmlQueryProcessor
{
public:
	SkeletonPublisher(CommonImpl::AuthenticationParams * authParams);
	virtual ~SkeletonPublisher();

///////////////////////////////////////////////////////////////////////////////
//	Methods implementing PublicationShim
///////////////////////////////////////////////////////////////////////////////
	//macro required by DirXML interface definition (see define_interface.h)
	DECLARE_IMPL(PublicationShim);
	//methods
	virtual XmlDocument * METHOD_CALL init(XmlDocument * shimParameters);
	virtual XmlDocument * METHOD_CALL start(XmlCommandProcessor * ndsExecute);

///////////////////////////////////////////////////////////////////////////////
//	Methods implementing XmlQueryProcessor
///////////////////////////////////////////////////////////////////////////////
	//macro required by DirXML interface definition (see define_interface.h)
	DECLARE_IMPL(XmlQueryProcessor);
	//methods
	XmlDocument * METHOD_CALL
		query(XmlDocument * document);

	//implementation details
	void stop(void);
	void abort(void);

protected:
	//use CommonImpl rather than deriving from to avoid multiple inheritance
	CommonImpl	common;
	//authorization values from driver shim init
	const CommonImpl::AuthenticationParams	* authParams;
	//variables used to signal start() to exit
	volatile bool shutdown;
	volatile bool aborted;
	//seconds between attempts to poll application
	int	pollingInterval;
	//filter used to filter application events before sending them to DirXML
	DriverFilter	* filter;
	//semaphore used in start() for waiting during poll attempts
	SEMAPHORE_HANDLE	semaphore;
	static const CommonImpl::ShimParamDesc PUBLISHER_PARAMS[]; 

	//Platform-specific implementations for semaphore support.
	static SEMAPHORE_HANDLE
		createSemaphore();
	static void
		waitSemaphore(SEMAPHORE_HANDLE semaphore, int timeoutInMilliseconds);
	static void
		signalSemaphore(SEMAPHORE_HANDLE semaphore);
	static void
		destroySemaphore(SEMAPHORE_HANDLE semaphore);

};

#endif	//#if !defined(_SKELETONPUBLISHER_H_)
