/*************************************************************************
Copyright  1999-2002 Novell, Inc. All Rights Reserved. 

THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND 
TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE
AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS
THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS
TO DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S
SAMPLE CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION
RIGHTS TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT
OF DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR
DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

***************************************************************************/
/*******************************************************************
* Name: SkeletonSubscriber.h
* Description: Platform independent code for CSkeletonDriver
* SubscriptionShim implementation
* Tabs: 4
*******************************************************************/


#if !defined(_SKELETONSUBSCRIBER_H_)
#define _SKELETONSUBSCRIBER_H_

#include	"NativeInterface.h"
#include	"CommonImpl.hpp"

class CSkeletonDriver;

//++
/*****************************************************************
Class: SkeletonSubscriber
Desc:
	Simple example implementation of the SubscriptionShim interface.

Notes:
	The <code>SubscriptionShim</code> defines an interface for an
	application driver to receive commands from DirXML. These
	commands must be executed on the application on behalf of DirXML.

*****************************************************************/
//--
class SkeletonSubscriber  
	:  public SubscriptionShim
{
public:
///////////////////////////////////////////////////////////////////////////////
//	Methods implementing SubscriptionShim
///////////////////////////////////////////////////////////////////////////////
	//macros required by DirXML interface definition (see define_interface.h)
	DECLARE_IMPL(XmlCommandProcessor);
	DECLARE_IMPL(SubscriptionShim);	
	//methods
	virtual XmlDocument * METHOD_CALL execute(XmlDocument * document, XmlQueryProcessor * queryInterface);
	virtual	XmlDocument * METHOD_CALL init(XmlDocument * shimParameters);

	//implementation details
	SkeletonSubscriber(const CommonImpl::AuthenticationParams * authParams);
	virtual ~SkeletonSubscriber();

	//subscriber stores some state between invocations - called by CSkeletonDriver::shutdown()
	void
		setState(Element * output);
	typedef	void (SkeletonSubscriber:: * COMMAND_HANDLER)(Element * command);

private:
	//use CommonImpl rather than deriving from to avoid multiple inheritance
	CommonImpl	common;
	//authorization values from driver shim init
	const CommonImpl::AuthenticationParams	* authParams;
	//other init parameters specific to the subscriber shim
	CommonImpl::ShimParams	* params;
	//used to determine if currently connected to application
	bool	connected;
	//<output> element of return document for use by command handlers
	Element	* outputElement;
	//This value is used to create an association in NDS between an NDS object and a
	//hypothetical object in the skeleton driver's supported application. See addHandler() definition
	int		currentAssociation;

	//example method that connects to supported application
	void
		connect();
	//dispatch to the handler corresponding to the XDS command
	void
		dispatch(Element * command);
	//handler for <add>
	void
		addHandler(Element * add);
	//handler for <modify>
	void
		modifyHandler(Element * modify);
	//handler for <delete>
	void
		deleteHandler(Element * deleteElement);
	//handler for <rename>
	void
		renameHandler(Element * rename);
	//handler for <move>
	void
		moveHandler(Element * move);
	//handler for <query>
	void
		queryHandler(Element * query);
	//get the association value from a command element
	const unicode *
		getAssociation(Element * element);
	//add driver identification data to output document
	void
		addDriverIdentification(Element * output);

	//implementation details for dispatch
	struct CommandEntry
	{
		const unicode	* commandName;
		COMMAND_HANDLER	handler;
	};

	static const CommandEntry	dispatchTable[];
	static const CommonImpl::ShimParamDesc SUBSCRIBER_PARAMS[];

};

//exception class used to signal connect problems
class ConnectException
	:	public	ShimException
{
public:
	ConnectException(const unicode * message);
};

void utftouni(char *,unicode *);
#endif //#if !defined(_SKELETONSUBSCRIBER_H_)
