/*************************************************************************
Copyright  1999-2002 Novell, Inc. All Rights Reserved. 

THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND 
TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE
AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS
THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS
TO DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S
SAMPLE CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION
RIGHTS TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT
OF DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR
DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

***************************************************************************/
/*******************************************************************
* Name: wcsfunc.h
* Description:	define macros for platforms to map the wcs* functions
*				to dsutil or other equivalents. Note that this is
*				used in dirxmllib, and that dirxmllib is designed to
*				be independent of ds for use with the remote infrastructure,
*				so dsutil equivalents must not be used if this is desired.
* level 1 core functionality
* Tabs: 4
*******************************************************************/

#ifndef _WCSFUNC_H_
#define	_WCSFUNC_H_


#if defined(WIN32)
//for Win32, include wchar.h so all the wcs* functions are declared
#include	<wchar.h>
#include	<string.h>
#endif	//#if defined(WIN32)

#if defined(NETWARE) || defined(__NETWARE__)

#include	<string.h>
#include	<unicode.h>

//prototypes for functions in netware wcsfunc.c
#if defined(__cplusplus)
extern "C" {
#endif

//function declarations for unicode to multibyte conversions for netware
size_t nw_wcstombs(char * mbstr, const unicode * wcstr, size_t count);
size_t nw_mbstowcs(unicode * wcstr, const char * mbstr, size_t count);
//function declaration for wcsncpy functionality for netware
unicode * nw_wcsncpy(unicode * strDest, const unicode * strSource, size_t count);

//functions from wcsfunc.cpp
extern unsigned long ucstoul(const unicode * nptr,unicode ** endptr,int base);

#if defined(__cplusplus)
}
#endif


//map various standard wide string handling functions to functions that
//are available to us in netware
#define wcslen(s) unilen((unicode *)s)
#define wcscpy(d,s) unicpy((unicode *)d,(unicode *)s)
#define wcscmp(s1,s2) uniicmp((unicode *)s1,(unicode *)s2)
#define wcsicmp(s1,s2) uniicmp((unicode *)s1,(unicode *)s2)
#define wcscat(d,s) unicat((unicode *)d,(unicode *)s)
#define	_wcsnicmp(s1,s2,n) uninicmp((unicode *)s1,(unicode *)s2,n)
#define wcsstr(s1,s2) uniindex((unicode *)s1,(unicode *)s2)
#define wcschr(s1,c) unichr((unicode *)s1,(int)c)
#define	wcsncpy(d,s,n) nw_wcsncpy(d,s,n)
#define	wcstombs(s1,s2,c) nw_wcstombs(s1,s2,c)
#define	mbstowcs(s1,s2,c) nw_mbstowcs(s1,s2,c)
#define	wcstoul(s,ep,b) ucstoul((unicode *)s,(unicode **)ep,b)

#if !defined(DS_FOR_UNIX)
//map non-ansi string handling functions to stuff available in netware using /za compiling
#define stricmp(s1,s2) CStriCmp((void *)(s1),(void *)(s2))
#else
#define stricmp(s1,s2) strcasecmp(s1,s2)
#endif //!defined(DS_FOR_UNIX)


#endif	//#if defined(NETWARE) || defined(__NETWARE__) || defined (DS_FOR_UNIX)

#if defined(DS_FOR_UNIX)
#include	<string.h>
#if defined(__cplusplus)
extern "C" {
#endif

size_t ustrlen(const unicode *ustr);
unicode * ustrcat(unicode *udstr,const unicode *usstr);
unicode * ustrcpy(unicode *udstr,const unicode *usstr);
int ustrcmp(const unicode *ustr1,const unicode *ustr2);
unsigned long ustrtoul(const unicode * s, const unicode ** ep, int base);
int ustricmp(const unicode * s1, const unicode * s2);

#define wcslen(s) ustrlen((unicode *)s)
#define wcscpy(d,s) ustrcpy((unicode *)d,(unicode *)s)
#define wcscmp(s1,s2) ustrcmp((unicode *)s1,(unicode *)s2)
#define wcsicmp(s1,s2) ustricmp((unicode *)s1,(unicode *)s2)
#define wcscat(d,s) ustrcat((unicode *)d,(unicode *)s)
#define	wcstoul(s,ep,b) ustrtoul((unicode *)s,(const unicode **)ep,b)

#if defined(__cplusplus)
}
#endif
#endif

#endif	//#ifndef _WCSFUNC_H_
