/*************************************************************************
 Copyright  2000-2003 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
 TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE
 AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS
 THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS
 TO DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S
 SAMPLE CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION
 RIGHTS TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT
 OF DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR
 DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.
 ************************************************************************/

package com.novell.nds.dirxml.driver.vrtest;


import org.w3c.dom.*;
import com.novell.nds.dirxml.driver.xds.*;


/** Package private error messages. */
class Errors
{

    static final public String NO_DN = "Object missing required dn.";
    static final public String NO_NAME = "Object missing name.";
    static final public String NO_PATH = "Object missing path.";
    static final public String NO_PARENT = "Parent object not found.";
    static final public String NO_ASSOCIATION = "Object missing required association.";


    static public String noAttributeValue(String attrName)
    {
        return "Missing required attribute value for attribute '" + attrName + "'.";
    }//noAttributeValue():String


    static public String noAddAttr(String attrName)
    {
        return "Missing element <add-attr attr-name=" + attrName + "/>.";
    }//noAddAttr(String):String


    static public String badDN(String dn)
    {
        return "Malformed distinguished name '" + dn + "'.";
    }//badDN(String):String


    static public String nullParam(String paramName)
    {
        return "Null parameter '" + paramName + "'.";
    }//nullParam(String):String


    static public String noClassSchema(String className)
    {
        return "Class '" + className + "' is undefined.";
    }//noClassSchema(String):String


    static public String noAttributeSchema(String attributeName)
    {
        return "Attribute '" + attributeName + "' is undefined.";
    }//noAttributeSchema(String):String


    static public String unsupportedEventType(String type)
    {
        return "Unsupported event type '" + type + "'.";
    }//unsupportedEventType(String):String


    static public String badPath(String path)
    {
        return "Malformed path '" + path + "'.";
    }//badPath(String):String


    static String noParamValue(String paramName)
    {
        return "No value passed for parameter '" + paramName + "'.";
    }//noParamValue(String):String

}//class Errors

