/*************************************************************************
 Copyright  2000-2003 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
 TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE
 AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS
 THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS
 TO DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S
 SAMPLE CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION
 RIGHTS TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT
 OF DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR
 DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.
 ************************************************************************/

package com.novell.nds.dirxml.driver.vrtest;


import com.novell.nds.dirxml.vrtest.*;


/**
 *	A <code>VRTestAttributeList</code> wrapper that holds
 *	<code>VRTestAttribute</code> objects with action
 *	<code>VRTestAction.MATCH</code>.
 */
class VRTestAttributeFilter
        extends VRTestAttrContainer
        implements VRTestAddAttrContainer
{

    static final public VRTestAttributeFilter ALL_ATTRIBUTES = new VRTestAttributeFilter();
    static final public VRTestAttributeFilter NO_ATTRIBUTES = new VRTestAttributeFilter();


    VRTestAttributeFilter()
    {
    }


    public void addAttribute(String name,
                             String value //can be null
                             )
            throws VRTestException
    {
        //null value == any value
        attributes.addAttribute(name, value, VRTestAction.MATCH);
    }//addAttribute(String, String):void


    public void addAttribute(String name)
            throws VRTestException
    {
        //null value == any value
        attributes.addAttribute(name, VRTestAttribute.ANY_VALUE, VRTestAction.MATCH);
    }//addAttribute(String):void


    public void clear()
    {
        attributes = new VRTestAttributeList();
    }//clear():void

} //class VRTestAttributeFilter

