/*************************************************************************
 Copyright  2000-2003 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
 TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE
 AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS
 THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS
 TO DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S
 SAMPLE CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION
 RIGHTS TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT
 OF DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR
 DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.
 ************************************************************************/

package com.novell.nds.dirxml.driver.vrtest;


import java.util.*;


/** A class filter with dynamic case sensitivity properties. */
//package


class VRTestClassFilter
        implements Constants
{

    VRTestFilterName className;
    Vector attributeNames;


    //package
    VRTestClassFilter(String someName)
    {
        className = new VRTestFilterName(someName);
        attributeNames = new Vector();
    }//VRTestClassFilter(String)


    //package
    Enumeration
            enumAttributeNames()
    {
        return attributeNames.elements();
    }//enumAttributeNames()


    //package
    boolean
            hasClassName(String someName)
    {
        return className.equals(someName);
    }//hasClassName(String)


    //package
    VRTestFilterName
            getClassName()
    {
        return className;
    }//getClassName()


    //package
    void
            addAttribute(String someName)
    {
        attributeNames.addElement(new VRTestFilterName(someName));
    }


    //package
    boolean
            passAttribute(String someName)
    {
        Enumeration names;
        VRTestFilterName attrName;

        names = attributeNames.elements();
        while (names.hasMoreElements())
        {
            attrName = (VRTestFilterName) names.nextElement();
            if (attrName.equals(someName))
            {
                return true;
            }
        }//while

        return false;
    }//passAttribute(String)


    //package
    String
            getFilterName(String someName)
    {
        Enumeration names;
        VRTestFilterName attrName;

        names = attributeNames.elements();
        while (names.hasMoreElements())
        {
            attrName = (VRTestFilterName) names.nextElement();
            if (attrName.equals(someName))
            {
                return attrName.toString();
            }
        }//while

        return null;
    }//getFilterName(String)

}//class VRTestClassFilter