/*************************************************************************
 Copyright  2000-2003 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
 TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE
 AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS
 THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS
 TO DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S
 SAMPLE CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION
 RIGHTS TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT
 OF DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR
 DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.
 ************************************************************************/

package com.novell.nds.dirxml.driver.vrtest;


import com.novell.nds.dirxml.vrtest.*;


/**
 *	Parses object information from a distinguished name
 *	of type <code>VRTestDNType</code>.
 */
class VRTestDNParser
        implements VRTestConstants, Constants
{

    private String name;
    private String path;


    VRTestDNParser(String dn, VRTestDNType type)
            throws VRTestException
    {
        parseObjectNameANDPath(dn, type);
    }//VRTestDNParser(String, VRTestDNType)


    private void parseObjectNameANDPath(String dn,
                                        VRTestDNType type
                                        )
            throws VRTestException
    {
        path = ParseObjectPath(dn, type);
        name = dn.substring(path.length(), dn.length());
    }//parseObjectNameANDPath(String, VRTestDNType):void


    static String ParseObjectPath(String dn,
                                  VRTestDNType type
                                  )
            throws VRTestException
    {
        if (dn == null)
        {
            throw new IllegalArgumentException
                    (Errors.nullParam("dn"));
        }

        if (type == null)
        {
            throw new IllegalArgumentException
                    (Errors.nullParam("type"));
        }

        int beginIndex;

        if (type == VRTestDNType.VRTEST)
        {
            beginIndex = FIRST_INDEX;
        }
        else //DS
        {
            beginIndex = FIRST_INDEX + 1;
        }

        int pathBeginIndex = dn.indexOf(PATH_DELIMITER_CHAR, beginIndex);
        int pathEndIndex = dn.lastIndexOf(PATH_DELIMITER_CHAR) + 1;

        if ((pathBeginIndex == CHAR_NOT_FOUND) ||
                (pathEndIndex == CHAR_NOT_FOUND) ||
                (pathEndIndex < pathBeginIndex))
        {
            throw new VRTestException
                    (Errors.badDN(dn));
        }

        return dn.substring(pathBeginIndex, pathEndIndex);
    }//ParseObjectPath(String, VRTestDNType):String


    String getObjectName()
    {
        return this.name;
    }//getObjectName():String


    String getObjectPath()
    {
        return this.path;
    }//getObjectPath():String

}//class VRTestDNParser

