/*************************************************************************
 Copyright  2000-2003 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
 TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE
 AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS
 THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS
 TO DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S
 SAMPLE CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION
 RIGHTS TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT
 OF DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR
 DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.
 ************************************************************************/

package com.novell.nds.dirxml.driver.vrtest;


import java.util.*;

import org.w3c.dom.*;
import com.novell.nds.dirxml.vrtest.*;
import com.novell.nds.dirxml.driver.xds.*;


/** A collection of <code>VRTestClassFilter</code>s. */
class VRTestDriverFilter
{

    Vector classFilters;


    public VRTestDriverFilter(Element filterElement)
    {
        classFilters = new Vector();

        if (filterElement != null)
        {
            //filterElement is a <driver-filter> element
            //may have <allow-class> children
            NodeList list, attrList;
            Element allowClass;
            int i, j;

            i = 0;
            list = filterElement.getElementsByTagName(DTD.TAG_ALLOW_CLASS);
            while ((allowClass = (Element) list.item(i++)) != null)
            {
                String className;
                VRTestClassFilter classFilter;
                Element allowAttr;

                className = allowClass.getAttribute(DTD.ATTR_CLASS_NAME);
                classFilter = new VRTestClassFilter(className);
                classFilters.addElement(classFilter);
                attrList = allowClass.getElementsByTagName(DTD.TAG_ALLOW_ATTR);
                j = 0;
                while ((allowAttr = (Element) attrList.item(j++)) != null)
                {
                    classFilter.addAttribute(allowAttr.getAttribute(DTD.ATTR_ATTR_NAME));
                }
            }//while
        }//if
    }//VRTestDriverFilter(Element)


    private VRTestDriverFilter()
    {
    }


    public boolean passClass(String className)
    {
        return (getClassFilter(className) != null);
    }//passClass(String):boolean


    public VRTestClassFilter getClassFilter(String className)
    {
        Enumeration filters;
        VRTestClassFilter filter;

        filters = classFilters.elements();
        while (filters.hasMoreElements())
        {
            filter = (VRTestClassFilter) filters.nextElement();
            if (filter.hasClassName(className))
            {
                return filter;
            }
        }//while

        return null;
    }//getClassFilter(String):VRTestClassFilter


    void setProperties(VRTestSchema schema)
    {
        Enumeration filters;
        VRTestClassFilter filter;
        Enumeration attributeNames;
        VRTestFilterName className, attributeName;
        VRTestClassSchema classSchema;
        VRTestAttributeSchema attributeSchema;

        filters = classFilters.elements();
        while (filters.hasMoreElements())
        {
            filter = (VRTestClassFilter) filters.nextElement();
            className = filter.getClassName();
            classSchema = schema.getClassSchema(className.toString());
            if (classSchema != null)
            {
                className.setCaseSensitive(classSchema.isCaseSensitive());
                attributeNames = filter.enumAttributeNames();
                while (attributeNames.hasMoreElements())
                {
                    attributeName = (VRTestFilterName) attributeNames.nextElement();
                    attributeSchema = classSchema.getAttributeSchema(attributeName.toString());
                    if (attributeSchema != null)
                    {
                        attributeName.setCaseSensitive(attributeSchema.isCaseSensitive());
                    }
                }//while
            }//if
        }//while
    }//setProperties(VRTestSchema):void

}//class VRTestDriverFilter