/*************************************************************************
 Copyright  2000-2003 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
 TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE
 AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS
 THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS
 TO DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S
 SAMPLE CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION
 RIGHTS TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT
 OF DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR
 DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.
 ************************************************************************/

package com.novell.nds.dirxml.driver.vrtest;


/** A filter name with dynamic case sensitivity properties. */
class VRTestFilterName
        implements Constants
{

    private String name;
    boolean caseSensitive;


    VRTestFilterName(String someName)
    {
        name = someName;
        caseSensitive = false;
    }//VRTestFilterElement(String)


    String getName()
    {
        return this.name;
    }//getName():String


    void setCaseSensitive(boolean value)
    {
        caseSensitive = value;
    }//setCaseSensitive(boolean):void


    public boolean equals(Object o)
    {
        if (o == null)
        {
            return false;
        }
        else if (o.getClass() == String.class)
        {
            return equals((String) o);
        }
        else if (o.getClass() == VRTestFilterName.class)
        {
            return equals(o.toString());
        }
        else
        {
            return false;
        }
    }//equals(Object):boolean


    public boolean equals(String someName)
    {
        if (someName == null)
        {
            return false;
        }
        else
        {
            if (caseSensitive)
            {
                if (name.compareTo(someName) == SAME_STRING)
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }//if
            else //case insensitive
            {
                if (name.equalsIgnoreCase(someName))
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }//else
        }//else
    }//equals(String):boolean


    public String toString()
    {
        return name;
    }//toString():String

}//class VRTestFilterName