/*************************************************************************
 Copyright  2000-2003 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
 TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE
 AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS
 THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS
 TO DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S
 SAMPLE CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION
 RIGHTS TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT
 OF DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR
 DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.
 ************************************************************************/

package com.novell.nds.dirxml.driver.vrtest;


import java.io.*;
import java.util.*;

import com.novell.nds.dirxml.vrtest.*;


/** A modified object on the VRTest server. */
//package


class VRTestModifiedObject
        extends VRTestObject
{

    private VRTestAttributeList modifiedAttributes;


    /*package*/
    VRTestModifiedObject
            (
            long aHandle,
            String aName,
            String aClassName,
            VRTestAttributeList someAttributes,
            VRTestAPIWrapper anAPI
            )
            throws VRTestException,
            IOException
    {
        super(aHandle, aName, aClassName, anAPI);
        modifiedAttributes = someAttributes;
    } //VRTestModifiedObject(long, String, String, VRTestAttributeList, VRTestAPIWrapper)


    //package
    List
            getModifiedAttributes()
    {
        return modifiedAttributes.attributes();
    } //getModifiedAttributes()


    //package
    boolean //removed value
            renamed(LinkedList newNames)
            throws VRTestException
    {
        LinkedList matches;

        matches = modifiedAttributes.getAttribute(getNamingAttributeSchema());
        if (matches == null)
        {
            //null == no modifications to UNIQUE_ID
            return false;
        }
        else
        {
            boolean multiValued;
            boolean removed;
            VRTestAttribute namingAttribute;
            VRTestAction action;
            ListIterator iterator;

            removed = false;
            multiValued = namingAttributeSchema.isMultiValued();
            iterator = matches.listIterator();
            while (iterator.hasNext())
            {
                namingAttribute = (VRTestAttribute) iterator.next();
                action = namingAttribute.getAction();
                if (action == VRTestAction.ADD)
                {
                    //single or multi-valued
                    if (!multiValued)
                    {
                        removed = true;
                    }
                    newNames.add(namingAttribute.getValue());
                }
                else if (action == VRTestAction.REMOVE)
                {
                    //won't see this unless it's multi-valued
                    removed = true;
                }
            }//while

            return removed;
        }//else
    }//getNewName()


    //package
    void
            removeCurrent()
    {
        modifiedAttributes.removeCurrent();
    }//removeCurrent()


    //package
    VRTestAttribute
            getAttributeByName(String attributeName)
            throws
            VRTestException,
            IOException
    {
        VRTestAttribute attribute;

        //try modified attributes first
        attribute = this.modifiedAttributes.getAttributeByName(attributeName);

        if (attribute == null)
        {
            //debug.comment("Attribute not found in modified attributes.");

            //try object attributes
            attribute = super.getAttributeByName(attributeName);
        }

        return attribute;
    }//getAttributeByName()


    //package
    String
            getNewPath()
    {
        if (hierarchical)
        {
            VRTestAttribute pathAttribute;

            pathAttribute = modifiedAttributes.getPath();
            if (pathAttribute == null)
            {
                return null;
            }
            else
            {
                modifiedAttributes.removeCurrent();
                return pathAttribute.getValue();
            }
        }//if
        else
        {
            return null;
        }
    } //getNewPath()


    //package
    boolean
            hasMoreModifiedAttributes()
    {
        return !modifiedAttributes.isEmpty();
    }//hasMoreModifiedAttributes()

} //class VRTestModifiedObject


