/*************************************************************************
 Copyright  2000-2003 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
 TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE
 AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS
 THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS
 TO DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S
 SAMPLE CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION
 RIGHTS TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT
 OF DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR
 DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.
 ************************************************************************/

package com.novell.nds.dirxml.driver.vrtest;


import com.novell.nds.dirxml.vrtest.*;


/**
 *	Parses container information from a VRTest object path.
 */
class VRTestPathParser
        implements VRTestConstants, Constants
{

    private String containerName;
    private String containerPath;
    private String containerDN;


    VRTestPathParser(String objectPath)
            throws VRTestException
    {
        if (objectPath == null)
        {
            throw new IllegalArgumentException
                    (Errors.nullParam("objectPath"));
        }

        parsePath(objectPath);
    }//VRTestPathParser(String)


    String getContainerName()
    {
        return containerName;
    }//getContainerName():String


    String getContainerPath()
    {
        return containerPath;
    }//getContainerPath():String


    String getContainerDN()
    {
        return containerDN;
    }//getContainerDN():String


    private void parsePath(String objectPath)
            throws VRTestException
    {
        int endDelimIndex;

        endDelimIndex = objectPath.lastIndexOf(PATH_DELIMITER_CHAR);
        if (endDelimIndex == CHAR_NOT_FOUND)
        {
            throw new VRTestException
                    (Errors.badPath(objectPath));
        }

        if (endDelimIndex == FIRST_INDEX) //case:  \
        {
            containerName = VRTestRootObject.NAME;
            containerPath = VRTestRootObject.PATH;
            containerDN = VRTestRootObject.DN;
        }
        else //case:  ...\name\
        {
            int beginDelimIndex;

            beginDelimIndex = objectPath.lastIndexOf(PATH_DELIMITER_CHAR, endDelimIndex - 1);
            if (beginDelimIndex == CHAR_NOT_FOUND)
            {
                throw new VRTestException
                        (Errors.badPath(objectPath));
            }

            containerName = objectPath.substring(beginDelimIndex + 1, endDelimIndex);

            int dnBeginDelimIndex = objectPath.indexOf(PATH_DELIMITER_CHAR);
            containerDN = objectPath.substring(dnBeginDelimIndex, endDelimIndex);
            //strip trailing '\' char

            endDelimIndex = beginDelimIndex;
            beginDelimIndex = objectPath.indexOf(PATH_DELIMITER_CHAR);
            containerPath = objectPath.substring(beginDelimIndex, endDelimIndex + 1);
            //include end delimiter
        }
    }//parsePath(String):void

}//class VRTestPathParser

