/*************************************************************************
 Copyright  2000-2003 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
 TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE
 AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS
 THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS
 TO DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S
 SAMPLE CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION
 RIGHTS TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT
 OF DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR
 DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.
 ************************************************************************/

package com.novell.nds.dirxml.driver.vrtest;


import java.util.*;

import com.novell.nds.dirxml.vrtest.*;


/** A dummy object representing root on the VRTest server. */
class VRTestRootObject
        extends VRTestObject
        implements Constants
{

    static final /*package*/ String NAME = null;
    static final /*package*/ String PATH = null;
    static final /*package*/ String DN = PATH_DELIMITER_STRING;


    private String childPath;


    VRTestRootObject()
    {
        super(NAME,
              PATH,
              DN,
              ZERO_STRING);

        childPath = PATH_DELIMITER_STRING;
    }//VRTestRootObject()


    String extractAssociationText()
    {
        return association;
    }//extractAssociationText():String


    VRTestAttribute getAttributeByName(String name)
    {
        return null;
    }//getAttributeByName(String):VRTestAttribute


    List getAttributes()
    {
        return attributes.attributes();
    }//getAttributes():List


    List getAttributes(VRTestAttributeFilter filter)
    {
        return attributes.attributes();
    }//getAttributes(VRTestAttributeFilter):List


    String getClassName()
    {
        return className;
    }//getClassName():String


    VRTestClassSchema getClassSchema()
    {
        return classSchema;
    }//getClassSchema():VRTestClassSchema


    String getDN()
    {
        return dn;
    }//getDN():String


    String getName()
    {
        return name;
    }//getName():String


    String getPath()
    {
        //the root object doesn't have a path
        return path;
    }//getPath():String


    boolean hasAssociation(String someAssociation)
    {
        if (someAssociation == null)
        {
            return false;
        }
        else
        {
            //case sensitive?
            return (association.compareTo(someAssociation) == SAME_STRING);
        }
    }//hasAssociation(String):boolean


    boolean hasDN(String someDN)
    {
        if (someDN == null)
        {
            return false;
        }
        else
        {
            //case sensitive?
            return (dn.compareTo(someDN) == SAME_STRING);
        }
    }//hasDN(String):boolean


    String getChildPath()
    {
        return childPath;
    }//getChildPath():String


    boolean hasName(String someName)
    {
        return (someName == name);
    }//hasName(String):boolean

}//class VRTestRootObject

