<!-------------------------------------------------------------------
$name: index.jsp
$version: 1.0
$date_modified: 03/00/2001
$description: Front page for the DSML Web service

$OpenLDAP$

Copyright (c) 2001 Novell, Inc. All Rights Reserved.

THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
CUSTOMERS WITH RESPECT TO THIS CODE.
---------------------------------------------------------------------->

<!-- -->

<%@ page
    language="java"
    import="javax.naming.InitialContext,
            javax.xml.rpc.Stub,
            javax.xml.parsers.DocumentBuilderFactory,
            javax.xml.parsers.DocumentBuilder,
            org.w3c.dom.*,
            sample_consumers.*,
            org.w3c.dom.NodeList"
%>

<html>

<center>
<a href="http://novell.com" target="blank_"><img src="/novell-dsml/graphics/novell_logo.gif" border="0"></a>
</center>
<Center>
    <title>Sample jsp page for consuming the DSML for eDirectory as a web service</title>
    <h1>DSMLv2 for eDirectory</h1>
    <h2>Congratulations! If you can see this page then the DSML for
    eDirectory web service is correctly installed and running.</h2>

    <p>This web service allows standard web services and clients to use XML and
    SOAP to connect to eDirectory and other standard LDAPv3 directories.
    Information about this web service, such as the
    <A href="/novell-dsml/jbroker?wsdl">WSDL document</a>, and
    <A href="/novell-dsml/jbroker?rmi">remote interface</a> is located at
    <A href="/novell-dsml/jbroker">novell-dsml/jbroker</a>.</p>

    <p>To verify that the DSML service is able to access eDirectory, information
    read from the RootDSE should be displayed below:
    </p>
    <hr WIDTH="95%">
</center>

<%! NodeList attr;
    final String VENDOR = "vendorVersion";
    final String VERSION= "supportedLDAPVersion";
    final String TREE   = "directoryTreename";
%>
<%
    // get the initial context
    InitialContext ctx = new InitialContext();
    String dsmlFile = "dsml.xml";
    // lookup the service for Hello
    DsmlClientService svc = (DsmlClientService)
        ctx.lookup("xmlrpc:soap:sample_consumers.DsmlClientService");

    // get the hello stub
    DsmlClient dsml = (DsmlClient) svc.getDsmlClientPort();

    // set the end point address
    String SERVER_NAME = request.getServerName();
    int SERVER_PORT = request.getServerPort();
    ((Stub)dsml)._setProperty("javax.xml.rpc.service.endpoint.address",
            "http://"+SERVER_NAME+":"+SERVER_PORT+"/novell-dsml/jbroker");

    // Load DSML document
    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    DocumentBuilder builder = factory.newDocumentBuilder();
    Document doc = builder.newDocument();
    Element bReq = doc.createElementNS("urn:oasis:names:tc:DSML:2:0:core",
            "batchRequest");
    Element search = doc.createElement("searchRequest");
    search.setAttribute("dn", "");
    search.setAttribute("scope", "baseObject");
    search.setAttribute("derefAliases", "neverDerefAliases");
    Element attrs = doc.createElement("attributes");
    Element attr1 = doc.createElement("attribute");
    Element attr2 = doc.createElement("attribute");
    Element attr3 = doc.createElement("attribute");
    attr1.setAttribute("name", VENDOR);
    attr2.setAttribute("name", VERSION);
    attr3.setAttribute("name", TREE);
    attrs.appendChild(attr1);
    attrs.appendChild(attr2);
    attrs.appendChild(attr3);
    search.appendChild(attrs);
    bReq.appendChild(search);

    // invoke the service
    Element bResp = dsml.batchRequest(bReq);
    attr = bResp.getElementsByTagName("attr");
%>
<body>
<H3>Root DSE:</H3>

<%
if (attr == null){
    %><BOLD>Configuration error: DSML Service could not find a directory</BOLD>
    <%
} else {
    %><Table><%
    for (int i=0; i<attr.getLength(); i++){
        Element searchResult = (Element)attr.item(i);
        Element value = (Element)searchResult.getFirstChild();
        Text text;
        if (value.hasChildNodes()){
            text = (Text)value.getFirstChild();
            %><TR>
                <TD><%= searchResult.getAttribute("name") %></TD>
                <TD><%= text.getNodeValue() %></TD>
              </TR>
            <%
        }
    }
    %></table><%
}%>
<hr WIDTH="95%">

<div align=right>
    <a href="http://www.silverstream.com" target="blank_"><img src="/novell-dsml/graphics/extend.gif" border="0" width="234" height="80"></a>    <br>
    Copyright &copy; 2003, <a href="http://www.silverstream.com" target="blank_">Novell, Inc</a>.
    <br>All rights reserved.
    <br><br><a href="http://developer.novell.com/edirectory" align=left target="blank_"><img src="/novell-dsml/graphics/eDir.gif" border="0"></a>
</div>
</body>
</html>
