/*******************************************************************************
 * $Novell: DSMLSoapClient.java,v 1.1 2003/08/26 10:39:44 $
 * Copyright (C) 1999, 2000, 2001 Novell, Inc. All Rights Reserved.
 *
 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
 * TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE
 * AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS
 * THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO
 * DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE
 * CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS
 * TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF
 * DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR
 * DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.
 *
 * $name:         DSMLSoapClient.java
 * $description:  This Sample Code allows you to perform any kind of directory
 *                operation e.g search,modify,add,delete on any LDAPServer using
 *                a DSML Document.
 *
 ******************************************************************************/

import java.io.*;
import java.net.*;
import java.util.Hashtable;
import javax.naming.Context;

 
public class DSMLSoapClient {

    
       
    public static void main(String[] args) throws Exception {
    	
	    if (args.length  < 4) {
            System.err.println("Usage:  java DSMLSoapClient " +
                               "http://DsmlURL dsmlfile.xml" +
                               " loginDN" + " userpassword");
            System.err.println("Example:");
            System.err.println("java DSMLSoapClient " +
                               "http://acme.com:8080/novell-dsml/stream " +
                               "e:\\dsml.xml \"cn=admin,o=acme\" \"secret\"");
            System.exit(1);
        }
        
        String DsmlURL      = args[0];
        String DsmlDoc      = args[1];
        String loginDN      = args[2];
        String password     = args[3];
        String cred;
        URL url;
        URLConnection connection;
        HttpURLConnection httpConn;
        
        String SOAPAction = "\"#batchRequest\"";
        cred=loginDN + ":" + password;
        String encoding  = new sun.misc.BASE64Encoder().encode (
                                                        cred.getBytes());
        
        // Create the connection where we're going to send the file.
        url = new URL(DsmlURL);
        connection = url.openConnection();
        connection.setRequestProperty ("Authorization", "Basic " + encoding);
        httpConn = (HttpURLConnection) connection;

        FileInputStream instr = new FileInputStream(DsmlDoc);
        ByteArrayOutputStream outstr = new ByteArrayOutputStream();
    
        // Copy the SOAP file to the open connection.
        copy(instr,outstr);
        instr.close();

        byte[] b = outstr.toByteArray();
        // Create the HTTP parameters.
        httpConn.setRequestProperty( "Content-Length",
                                     String.valueOf( b.length ) );
        httpConn.setRequestProperty("Content-Type","text/xml; charset=utf-8");
        httpConn.setRequestProperty("SOAPAction",SOAPAction);
        httpConn.setRequestMethod( "POST" );
        httpConn.setDoOutput(true);
        httpConn.setDoInput(true);
        // Write the XML that was read in to b.
        OutputStream out = httpConn.getOutputStream();
        out.write( b );    
        out.close();
        // Read the response returned from the DSML servlet and write it
        // to standard out.
        InputStreamReader ireader =
            new InputStreamReader(httpConn.getInputStream());
        BufferedReader in = new BufferedReader(ireader);

        String inputLine;
        System.out.println("\n--------------------------------------------------"
                           + "------------------------");
		System.out.println("\n                          DSML v2/SOAP Response");
		System.out.println("\n--------------------------------------------------"
		                   + "------------------------");
        while ((inputLine = in.readLine()) != null)
            System.out.println(inputLine);

        in.close();
    }

  
    public static void copy(InputStream in, OutputStream out) 
           throws IOException 
    {
        synchronized (in) {
            synchronized (out) {

                byte[] buffer = new byte[256];
                while (true) {
                    int bytesRead = in.read(buffer);
                    if (bytesRead == -1) break;
                    out.write(buffer, 0, bytesRead);
                }
            }
        }
    } 
}
