/*******************************************************************************

 * $Novell: GetAuthenticated.java,v 1.13 2002/07/29 21:17:42 $

 * Copyright (c) 2000 Novell, Inc. All Rights Reserved.

 *

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE

 * AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS

 * THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO

 * DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE

 * CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS

 * TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF

 * DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR

 * DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

 *

 * $name:         GetAuthenticated.java 

 * $description:  GetAuthenticated shows different kinds of bind.

 *                   -- anonymous bind 

 *                   -- simple bind

 *                   -- simple bind with connection method

 *                   -- SSL bind

 ******************************************************************************/

import java.io.UnsupportedEncodingException;

import com.novell.ldap.LDAPConnection;

import com.novell.ldap.LDAPException;

import com.novell.ldap.LDAPJSSESecureSocketFactory;



public class GetAuthenticated

{

    public static void main( String[] args ) {

        if (args.length != 3) {

            usage();

            System.exit(1);

        }



        int ldapVersion   = LDAPConnection.LDAP_V3;

        int ldapPort      = LDAPConnection.DEFAULT_PORT;

        int ldapSSLPort   = LDAPConnection.DEFAULT_SSL_PORT;

        String ldapHost   = args[0];

        String loginDN    = args[1];

        String password   = args[2];

        LDAPConnection conn = new LDAPConnection();



        anonymousBind( conn, ldapHost, ldapPort );



        simpleBind1( conn, ldapHost, ldapPort, loginDN, password );



        simpleBind2( ldapVersion, conn, ldapHost, ldapPort, loginDN, password );



        /* A JSSE Security provider must be manually configured in

           security.properties, or do something like the following to

           dynamically set a provider.

        */

        java.security.Security.addProvider(

            new com.sun.net.ssl.internal.ssl.Provider());



        /* The property "javax.net.ssl.trustStore" must be set to the path of a

           keystore that holds the certificate of the server

        */

        SSLBind( ldapVersion, ldapHost, ldapSSLPort, loginDN, password );



        System.exit(0);



    }



    private static void usage() {

        System.err.println(

          "Usage:   java GetAuthenticated <host Name> <login dn> <password>");

        System.err.println(

          "Example: java GetAuthenticated Acme.com \"cn=admin,o=Acme\" secret");

        System.err.println(

          "To set the keystore for JSSE: " +

          "java -Djavax.net.ssl.trustStore=/path/keystoreName.keystore ...");

    }



    private static void anonymousBind( LDAPConnection conn, String host,

                                         int port ) {

        try {

            System.out.println("\nanonymous bind...");

            // connect to the server

            conn.connect( host, port );

            

            System.out.println((conn.isBound()) ?

                "\n\tAuthenticated to the server\n":

                    "\n\tAnonymous bind to the server\n");

 

            // disconnect with the server

            conn.disconnect();

        }

        catch( LDAPException e ) {

            System.out.println( "Error: " + e.toString() );

        }

        return;

    }



    private static void simpleBind1(LDAPConnection conn, String host,

                                int port, String dn, String passwd ) {

        try {

            System.out.println("Simple bind...");

            // connect to the server

            conn.connect( host, port );

            // authenticate to the server

            try {

                conn.bind( LDAPConnection.LDAP_V3, dn, passwd.getBytes("UTF8") );

            } catch (UnsupportedEncodingException u){

                throw new LDAPException( "UTF8 Invalid Encoding",

                                         LDAPException.LOCAL_ERROR,

                                         (String)null, u);

            }

            

            System.out.println((conn.isBound()) ?

                "\n\tAuthenticated to the server ( simple )\n":

                    "\n\tNot authenticated to the server\n");



            // disconnect with the server

            conn.disconnect();

        }

        catch( LDAPException e ) {

            System.out.println( "Error: " + e.toString() );

        }

        return;

    }



    private static void simpleBind2(  int version, LDAPConnection conn,

                    String host, int port,String dn, String passwd ) {

        try {

            System.out.println("Simple bind with connection method...");

            // connect to the server

            conn.connect( host, port );

            // authenticate to the server with the connection method

            try {

                conn.bind( version, dn, passwd.getBytes("UTF8") );

            } catch (UnsupportedEncodingException u){

                throw new LDAPException( "UTF8 Invalid Encoding",

                                         LDAPException.LOCAL_ERROR,

                                         (String)null, u);

            }

            

            System.out.println((conn.isBound()) ?

                "\n\tAuthenticated to the server ( simple )\n":

                    "\n\tNot authenticated to the server\n");



            // disconnect with the server

            conn.disconnect();

        }

        catch( LDAPException e ) {

            System.out.println( "Error: " + e.toString() );

        }

        return;

    }

    

    private static void SSLBind( int version, String host, int SSLPort, 

                                                   String dn, String passwd ) {



        // Set the socket factory for this connection only

        LDAPJSSESecureSocketFactory ssf = new LDAPJSSESecureSocketFactory();

        LDAPConnection  conn = new LDAPConnection(ssf);

        

        try {

            System.out.println("SSL bind...");

            // connect to the server

            conn.connect( host, SSLPort);

            // authenticate to the server with the connection method

            try {

                conn.bind( version, dn, passwd.getBytes("UTF8") );

            } catch (UnsupportedEncodingException u){

                throw new LDAPException( "UTF8 Invalid Encoding",

                                         LDAPException.LOCAL_ERROR,

                                         (String)null, u);

            }



            System.out.println((conn.isBound()) ?

                "\n\tAuthenticated to the server ( ssl )\n":

                    "\n\tNot authenticated to the server\n");

                    

            // disconnect with the server

            conn.disconnect();

        }

        catch( LDAPException e ) {

            System.out.println( "Error: " + e.toString() );

        }

        return;

    }

}

