import java.io.FileInputStream;

import java.io.FileOutputStream;

import java.io.IOException;

import java.io.ObjectInputStream;

import java.io.ObjectOutputStream;

import java.io.UnsupportedEncodingException;



import com.novell.ldap.LDAPAttribute;

import com.novell.ldap.LDAPConnection;

import com.novell.ldap.LDAPEntry;

import com.novell.ldap.LDAPException;



/*******************************************************************************

 * $Novell: LDAPAttributeDSMLSerialization.java,v 1.2 2005/09/26 08:10:34 $

 * Copyright (c) 2000, 2001 Novell, Inc. All Rights Reserved.

 *

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE

 * AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS

 * THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO

 * DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE

 * CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS

 * TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF

 * DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR

 * DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

 *

 * $name:         LDAPAttributeDSMLSerialization.java

 * $description:  LDAPAttributeDSMLSerialization.java demonstrates how to

 * 				  use default DSML Serialization provided by Java LDAP APIs

 *                The program has two parts:

 * 				  Part - 1 # Demonstrates how to serializes a LDAPAttribute

 * 							 Object read from LDAP Directory Server into a 

 * 							 file provided by user during execution

 * 				  Part - 2 # Demonstrates how to deserializes the stored

 *  						 LDAPAttribute Object serialized in Part - 1

 ******************************************************************************/

public class LDAPAttributeDSMLSerialization {



	/**

	 * 

	 */

	public LDAPAttributeDSMLSerialization() {

		super();

		// TODO Auto-generated constructor stub

	}



	public static void main(String[] args) {

		//this is the check whether the option of being serialized/de-serialized

		// is being entered

		if (args.length < 1) {

			usage();

			System.exit(1);

		}



		String option = args[0];

		if(args[0].equalsIgnoreCase("-s"))

		{          

			if(args.length != 7)

			{

				usage();

				System.exit(1);

			}

			serialize(args);

		}

		else if(args[0].equalsIgnoreCase("-d"))

		{

			if(args.length != 2)

			{

				usage();

				System.exit(1);

			}

			deserialize(args);

		}

		else

		{

			usage();

			System.exit(1);

		}

		

	}



	public static void usage() {

		

		String tab="	";

		System.err.println("To serialize:");

		

	   System.err.println(tab + "Usage:   java LDAPAttributeDSMLSerialization" +
	   	" <-options> <host name> <login dn>\n     	      <password> " +

						"<entry dn> <attribute name> <file name>");

						

						

	   System.err.println(tab + "Example: java LDAPAttributeDSMLSerialization" +
	   	" -s Acme.com \"cn=admin,o=Acme\" \n     	      secret "

	   	+ "\"ou=sales,o=Acme\" \"cn\" \"/temp/attr.xml\"");

	   	

		System.err.println("\nTo de-serialize:");

		

	   System.err.println(tab + "Usage:   java LDAPAttributeDSMLSerialization" +

		" <-options> <file name>");

				

	   System.err.println(tab + "Example: java LDAPAttributeDSMLSerialization" +

		" -d \"/temp/attr.xml\""); 

		
	   System.err.println("\nwhere options include:\n" 

								+	tab + "-s   to serialize the Object\n"

								+   tab + "-d   to de-serialize the Object\n");

		  

	}

   private static void serialize(String[] args){

	int ldapPort = LDAPConnection.DEFAULT_PORT;

	int searchScope = LDAPConnection.SCOPE_ONE;

	int ldapVersion  = LDAPConnection.LDAP_V3;

	String ldapHost = args[1];

	String loginDN = args[2];

	String password = args[3];

	String dn = args[4]; //The distinguished name of the entry to retrieve.

	String attr = args[5];

	String attrs[] = {attr}; 

	boolean attributeOnly = false; 

	String fileName = args[6];

	LDAPConnection lc = new LDAPConnection();

	LDAPAttribute ldapattr = null;

	try {

		// connect to the server

		lc.connect( ldapHost, ldapPort );

		// bind to the server

		lc.bind( ldapVersion, loginDN, password.getBytes("UTF8") );

		

		LDAPEntry entry = lc.read(dn, attrs);

		if(entry == null)

		{

			System.out.println("No maching entry containing the attribute " +
				"found in search. Enter some different option and try again");

			System.exit(0);

		}

		ldapattr = entry.getAttribute(attr);

						

		// disconnect with the server

		lc.disconnect();

	}

	catch( LDAPException e ) {

		System.out.println( "Error: " + e.toString() );

	}

	catch( UnsupportedEncodingException e ) {

		System.out.println( "Error: " + e.toString() );

	} 

	

	if(ldapattr == null)

	{

		System.out.println("No maching attribute found in search. " +
			"Enter some different option and try again");

		System.exit(0);

	}



//	call serialization method

	try{

		ObjectOutputStream out =

			new ObjectOutputStream(

				new FileOutputStream(fileName));

	  

		out.writeObject(ldapattr);

		out.close();

		System.out.println("Object written =" + ldapattr.toString());

	}

	catch(IOException e){

		System.out.println( "Error: " + e.toString() );

	}

  }

   

   private static void deserialize(String[] args){

	String fileName = args[1];

//	call deserialization method

	try{

		ObjectInputStream in =

			new ObjectInputStream(

				new FileInputStream(fileName));

	  

		LDAPAttribute ldapattr = (LDAPAttribute)in.readObject();

		System.out.println("Object read =" + ldapattr.toString());

		in.close();	



	}

	catch(IOException io){

		System.out.println( "Error: " + io.toString() );

	}

	catch(ClassNotFoundException ce){

			System.out.println( "Error: " + ce.toString() );

		}    	

   	

	}

		

}

