/*******************************************************************************

 * $Novell: List.java,v 1.12 2003/08/21 11:33:48 $

 * Copyright (C) 1999, 2000, 2001 Novell, Inc. All Rights Reserved.

 *

 ** THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE

 * AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS

 * THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO

 * DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE

 * CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS

 * TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF

 * DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR

 * DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

 *

 * $name:         List.java

 * $description:  The List.java example returns all the entries in the specified

 *                container (search base). No attributes are returned.

 ******************************************************************************/

import com.novell.ldap.*;

import java.io.UnsupportedEncodingException;



public class List 

{

    public static void main( String[] args ) 

    {       

        if (args.length != 5) {

            System.err.println("Usage:   java List <host name> <login dn>"

                             + " <password> <search base>\n"

                             + "         <search filter>");

            System.err.println("Example: java List Acme.com \"cn=admin,o=Acme\""

                             + " secret \"ou=sales,o=Acme\"\n"

                             + "         \"(objectclass=*)\"");

            System.exit(1);

        }



        int ldapPort = LDAPConnection.DEFAULT_PORT;

        int searchScope = LDAPConnection.SCOPE_ONE;

        int ldapVersion  = LDAPConnection.LDAP_V3;;

        boolean attributeOnly = true;

        String attrs[] = {LDAPConnection.NO_ATTRS};                

        String ldapHost = args[0];

        String loginDN = args[1];

        String password = args[2];

        String searchBase = args[3];

        String searchFilter = args[4];

        LDAPConnection lc = new LDAPConnection();



        try {

            // connect to the server

            lc.connect( ldapHost, ldapPort );

            // bind to the server

            lc.bind( ldapVersion, loginDN, password.getBytes("UTF8") );



            LDAPSearchResults searchResults =

                lc.search(  searchBase,      // container to search

                            searchScope,     // search scope

                            searchFilter,    // search filter

                            attrs,           // "1.1" returns entry name only

                            attributeOnly);  // no attributes are returned



            // print out all the objects

            while ( searchResults.hasMore()) {

                LDAPEntry nextEntry = null;

                try {

                    nextEntry = searchResults.next();

                }

                catch(LDAPException e) {

                    System.out.println("Error: " + e.toString());



                    // Exception is thrown, go for next entry

                    continue;

                }



                System.out.println("\n" + nextEntry.getDN());

            }

            // disconnect with the server

            lc.disconnect();

        }

        catch( LDAPException e ) {

            System.out.println( "Error: " + e.toString() );

        }

        catch( UnsupportedEncodingException e ) {

            System.out.println( "Error: " + e.toString() );

        }        

        System.exit(0);

    }

}

