/*******************************************************************************

 * $Novell: ModifyAttrs.java,v 1.21 2003/08/21 11:35:10 $

 * Copyright (C) 1999, 2000, 2001 Novell, Inc. All Rights Reserved.

 *

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE

 * AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS

 * THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO

 * DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE

 * CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS

 * TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF

 * DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR

 * DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

 *

 * $name:         ModifyAttrs.java

 *

 * $description:  The ModifyAttrs example modifies the attributes of an entry.

 *                It also demonstrates the use of an ArrayList to store

 *                and indeterminate number of of modifications.

 ******************************************************************************/

import com.novell.ldap.*;

import java.util.Date;

import java.util.ArrayList;

import java.io.UnsupportedEncodingException;



public class ModifyAttrs 

{

    public static void main( String[] args ) 

    {        

        int returnCode = 0;

        if (args.length != 4) {

            System.err.println("Usage:   java ModifyAttrs <host name> "

                             + "<login dn> <password> <modify dn> ");

            System.err.println("Example: java ModifyAttrs Acme.com "

                             + "\"cn=Admin,o=Acme\" secret\n"

                             + "         \"cn=JSmith,ou=Sales,o=Acme\"");

            System.exit(1);

        }



        int ldapPort  = LDAPConnection.DEFAULT_PORT;

        int ldapVersion  = LDAPConnection.LDAP_V3;        

        Date currentDate = new Date();

        String ldapHost = args[0];

        String loginDN  = args[1];

        String password = args[2];

        String dn = args[3];

        LDAPConnection lc = new LDAPConnection();

        ArrayList modList = new ArrayList();



        /* To add a new value to an attribute (creates attribute if necessary)

         *     -- Specify the dn of the entry to modify

         *     -- Specify the attribute and value to add

         *     -- Specify the add modification type

         *     -- Add modification to the modification array

         *     -- Call LDAPConnection modify() method

        /* To replace values of an attribute (creates attribute if necessary)

         *     -- Specify the dn of the entry to modify

         *     -- Specify the attribute and new values to replace the old ones

         *     -- Specify the replace modification type

         *     -- Add modification to the modification array

         *     -- Call LDAPConnection modify() method

        /* To delete or modify a single attribute value

         *     -- Specify the dn of the entry to modify

         *     -- Specify the attribute and value to be modified

         *     -- Specify the delete modification type

         *     -- Add modification to the modification array

         * --  To add a new value in place of the one we just deleted

         *     -- Specify the same attribute and new its value

         *     -- Specify the add modification type

         *     -- Add modification to the modification array

         *     -- Call LDAPConnection modify() method

         */

        String desc =

            "This object was modified at " + new Date( currentDate.getTime());

        // Add a new value to the description attribute

        LDAPAttribute attribute = new LDAPAttribute( "description", desc);

        modList.add( new LDAPModification(LDAPModification.ADD, attribute));



        // Replace all values the E-mail address with a new value

        String email = "James_Smith@Acme.com";

        attribute = new LDAPAttribute( "mail", email);

        modList.add( new LDAPModification(LDAPModification.REPLACE, attribute));



        // Change the phone number

        //  First we delete the old phone number

        String phone1= "1 801 555 1212";

        attribute= new LDAPAttribute( "telephoneNumber", phone1);

        modList.add( new LDAPModification(LDAPModification.DELETE, attribute));



        //  Now we add the new phone number

        String phone2 = "1 423 555 1212";

        attribute= new LDAPAttribute( "telephoneNumber", phone2);

        modList.add( new LDAPModification(LDAPModification.ADD, attribute));



        LDAPModification[] mods = new LDAPModification[modList.size()]; 

        mods = (LDAPModification[])modList.toArray(mods);

      

        try {

            // connect to the server

            lc.connect( ldapHost, ldapPort);

            // bind to the server

            lc.bind( ldapVersion, loginDN, password.getBytes("UTF8") );

            

            // Add a known phone number value so we have something to change

            lc.modify( dn, new LDAPModification(

                    LDAPModification.ADD,

                    new LDAPAttribute( "telephoneNumber", "1 801 555 1212")));

        } catch( LDAPException e1) {

            // If phonenumber value already exists, just go on,

            //      otherwise it's an error

            if( e1.getResultCode() != LDAPException.ATTRIBUTE_OR_VALUE_EXISTS) {

                System.out.println("Cannot create attribute: " + e1.toString());

                System.exit(1);

            }

        }

        catch( UnsupportedEncodingException e ) {

            System.out.println( "Error: " + e.toString() );

        }

            

        // Note: All the above modifications will be performed as an atomic

        // unit, if all do not succeed, the operation fails and the

        // directory is unchanged by this operation.

        try {

            lc.modify( dn, mods);

            System.out.println(

                        "Successfully modified the attributes of the entry." );

        } catch( LDAPException e2 ) {

            // Tell what happened

            System.err.println( "Error: " + e2.toString() );

            

            // Indicate the operation failed

            returnCode = 1;

            

            // Didn't change the directory, delete initial phone number value

            try {

                lc.modify( dn, new LDAPModification( LDAPModification.DELETE,

                               new LDAPAttribute( "telephoneNumber", phone1)));

            } catch( Exception e) {

                // ignore

            }

        } finally {

            if( returnCode == 0) {

                try {

                    // Cleanup - get rid of the updated description, mail,

                    //           and telephone attribute values

                    // We delete only those values that we added.  If the

                    // value deleted is the only value of the respective

                    // attribute, then the attribute is deleted.

                    modList.clear();

                    modList.add(new LDAPModification( LDAPModification.DELETE,

                                new LDAPAttribute( "description", desc)));

                    modList.add(new LDAPModification( LDAPModification.DELETE,

                                new LDAPAttribute( "mail", email)));

                    modList.add(new LDAPModification( LDAPModification.DELETE,

                                new LDAPAttribute( "telephoneNumber", phone2)));

                    mods = new LDAPModification[modList.size()]; 

                    mods = (LDAPModification[])modList.toArray(mods);

                    lc.modify( dn, mods);

                } catch( Exception e) {

                    // ignore

                }

            }

            // Always disconnect

            try {

                lc.disconnect();

            } catch( Exception e) {

                // ignore

            }

        } 

        System.exit(returnCode);

    }

}

