/*******************************************************************************

 * $Novell: SetPassword.java,v 1.16 2003/08/21 11:37:00 $

 * Copyright (C) 1999, 2000, 2001 Novell, Inc. All Rights Reserved.

 *

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE

 * AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS

 * THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO

 * DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE

 * CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS

 * TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF

 * DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR

 * DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

 *

 * $name:           SetPassword.java

 * $description:    The SetPassword.java sample shows how to set the password

 *                  of an entry by setting the userPassword attribute

 *                  of the entry.

 *

 *                  In Novell eDirectory, only an admin can set a password

 *                  without supplying the old password.  Consequently this

 *                  method works on any Novell LDAP server, but only when the

 *                  caller has admin privileges.  Users cannot change their

 *                  own password with this method (see ModifyPassword.java).

 ******************************************************************************/

import com.novell.ldap.*;

import java.io.UnsupportedEncodingException;



public class SetPassword 

{

    public static void main( String[] args ) 

    {        

        if (args.length != 5) {

            System.err.println("Usage:   java SetPassword <host name> "

                             + "<login dn> <password>\n"

                             + "         <modify dn> <new password>");

            System.err.println("Example: java SetPassword Acme.com "

                            + "\"cn=Admin,o=Acme secret\"\n"

                            + "         \"cn=JSmith,ou=Sales,o=Acme\"" 

                            + " newPassword");

            System.exit(1);

        }



        int ldapPort = LDAPConnection.DEFAULT_PORT;

        int ldapVersion = LDAPConnection.LDAP_V3;        

        String ldapHost = args[0];

        String loginDN = args[1];

        String password = args[2];

        String ModifyDN = args[3];

        String NewPassword = args[4];

        LDAPConnection lc = new LDAPConnection();



         /* To set a user's password,

          *   -- User should have administrator privileges

          *   -- Specify the new password value to be set

          *   -- Specify the modify type (replace for this operation)

          *   -- Add the new value and type to the modification set

          *   -- Call LDAPConnection modify method to set the password

          */



        try {

            // connect to the server

            lc.connect( ldapHost, ldapPort );

            // authenticate to the server

            lc.bind( ldapVersion, loginDN, password.getBytes("UTF8") );



            LDAPAttribute attributePassword = new LDAPAttribute( "userPassword",

                                                                NewPassword);

            lc.modify( ModifyDN, new LDAPModification(

                                LDAPModification.REPLACE, attributePassword) );



            System.out.println( "Successfully set the user's password" );



            // disconnect with the server

            lc.disconnect();

        }

        catch( LDAPException e ) {

            if ( e.getResultCode() == LDAPException.NO_SUCH_OBJECT ) {

                System.err.println( "Error: No such entry" );

            } else if ( e.getResultCode() ==

                                LDAPException.INSUFFICIENT_ACCESS_RIGHTS ) {

                System.err.println( "Error: Insufficient rights" );

            } else {

                System.err.println( "Error: " + e.toString() );

            }        

        }

        catch( UnsupportedEncodingException e ) {

            System.out.println( "Error: " + e.toString() );

        }

        System.exit(0);

    }

}

