/*******************************************************************************

 * $Novell: UrlSearch.java,v 1.12 2002/07/29 21:17:45 $

 * Copyright (C) 2000, 2001 Novell, Inc. All Rights Reserved.

 *

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE

 * AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS

 * THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO

 * DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE

 * CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS

 * TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF

 * DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR

 * DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

 *

 * $name:         UrlSearch.java

 * $version:      1.0

 * $description:  UrlSearch.java shows how to use the APIs from the class of

 *                LDAPUrl. The Url in the usage message is:

 *                    ldap://Acme.com:389/ou=sales,o=Acme?cn,sn,telephoneNumber?

 *                    one?(objectclass=*)

 *                The components for the Url includes

 *                    ldap: protocol prefix;

 *                    Acme.com:389: LDAP host and TCP port number. ":389" can

 *                        be omitted since it's the default TCP port number;

 *                    ou=sales,o=Acme: Distinguished name of the base object

 *                        of the LDAP search;

 *                    cn,sn,telephoneNumber: to indicate which attributes should

 *                        be returned from the entry or entries. Using the

 *                        special attribute name "*" will return all the

 *                        attributes of the entry or entries;

 *                    one: search scope. It can be "base", "one", or "sub". If

 *                        users do not specify the search scope, "base" is used

 *                        as the default value;

 *                    (objectclass=*): search filter. (objectclass=*) can be

 *                        omitted since it's the default filter.

 ******************************************************************************/

import com.novell.ldap.*;

import java.util.Enumeration;

import java.util.Iterator;

import java.net.MalformedURLException;



public class UrlSearch

{

    public static void main( String[] args )

    {

        if (args.length != 1) {

            System.err.println("Usage:   java UrlSearch <url>");

            System.err.println("Example: java UrlSearch \"ldap://Acme.com:389/"

                                        + "ou=sales,o=Acme\n"

                                        + "         ?cn,sn,telephoneNumber?one?"

                                        + "(objectclass=*)\"");

            System.exit(1);

        }



        String inUrl = args[0];

        LDAPUrl myUrl;

        LDAPConnection lc = new LDAPConnection();



        try {

            /* construct LDAPUrl object */

            myUrl = new LDAPUrl( inUrl);



            /* Print out the input URL */

            System.out.println( "Input Url: " + inUrl );



            /* Print out the encoded URL */

            String encodedUrl = myUrl.encode(inUrl);

            System.out.println( "Encoded Url: " + encodedUrl );



            /* Print out each of the URL parameters */

            System.out.println( "ldapHost: " + myUrl.getHost());

            System.out.println( "ldapPort: " + myUrl.getPort());

            System.out.println( "searchBase: " + myUrl.getDN());

            String attrArray[] = myUrl.getAttributeArray();

            if (attrArray != null) {

                System.out.print("attributes to return: ");

                for (int i = 0; i < attrArray.length; i++) {

                    System.out.print( (i < attrArray.length - 1)?

                        attrArray[i] + ", ": attrArray[i]);

                }

            }

            else

                System.out.print("attributes to return: all the attributes");

            System.out.println();

            System.out.println( "searchScope: " + myUrl.getScope());

            System.out.println( "searchFilter: " + myUrl.getFilter());



            // URL search will connect to the server, search the

            // directory, and then disconnect with the server

            LDAPSearchResults searchResults = lc.search( myUrl );



            while ( searchResults.hasMore()) {

                LDAPEntry nextEntry = searchResults.next();

                System.out.println("\n" + nextEntry.getDN());



                LDAPAttributeSet attributeSet = nextEntry.getAttributeSet();

                Iterator allAttributes = attributeSet.iterator();



                if (allAttributes.hasNext())

                    System.out.println("    Attribute(s): ");



                while(allAttributes.hasNext()) {

                    LDAPAttribute attribute =

                                (LDAPAttribute)allAttributes.next();

                    String attributeName = attribute.getName();

                    Enumeration allValues = attribute.getStringValues();



                    while(allValues.hasMoreElements()) {

                        String Value = (String) allValues.nextElement();

                        System.out.println("        " + attributeName

                                                         + ": " + Value);

                    }

                }

            }

        }

        catch( MalformedURLException e ) {

           System.out.println( "Error: " + e.toString() );

        }

        catch( LDAPException e ) {

           System.out.println( "Error: " + e.toString() );

        }

        System.exit(0);

    }

}

