/**************************************************************************

 * $Novell: DomClientObj.java,v 1.2 2003/02/18 17:40:00 $

 *

 * Copyright (C) 2003 Novell, Inc. All Rights Reserved.

 *

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE, MODIFICATION, AND REDISTRIBUTION OF THIS WORK IS SUBJECT

 * TO VERSION 2.0.1 OF THE OPENLDAP PUBLIC LICENSE, A COPY OF WHICH IS

 * AVAILABLE AT HTTP://WWW.OPENLDAP.ORG/LICENSE.HTML OR IN THE FILE "LICENSE"

 * IN THE TOP-LEVEL DIRECTORY OF THE DISTRIBUTION. ANY USE OR EXPLOITATION

 * OF THIS WORK OTHER THAN AS AUTHORIZED IN VERSION 2.0.1 OF THE OPENLDAP

 * PUBLIC LICENSE, OR OTHER PRIOR WRITTEN CONSENT FROM NOVELL, COULD SUBJECT

 * THE PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.

 ***************************************************************************/ 

package sample_consumers;



import javax.servlet.http.HttpServletRequest;

import java.util.Vector;

import java.util.Enumeration;

import javax.naming.InitialContext;

import javax.xml.rpc.Stub;

import javax.xml.parsers.DocumentBuilderFactory;

import javax.xml.parsers.DocumentBuilder;

import org.w3c.dom.Attr;

import org.w3c.dom.Document;

import org.w3c.dom.Element;

import org.w3c.dom.Node;

import org.w3c.dom.NamedNodeMap;

import org.w3c.dom.NodeList;



public class DomClientObj {    

      

    public  Document doc;

    public  DsmlClient dsml;



    private InitialContext ctx;

    private DsmlClientService svc;

    private DocumentBuilderFactory factory;

    private DocumentBuilder builder;    

    private Vector v = new Vector(); // save parsed lins of dsml 

    private String identation = "";  // can not be static





    // default constructor

    public DomClientObj() {

        setDomClientObj();  

    }         



    private void setDomClientObj() {    

        try {                                                      

            // get initial context

            ctx = new InitialContext();            

            // get service

            svc = (DsmlClientService)

               ctx.lookup("xmlrpc:soap:sample_consumers.DsmlClientService");       

            // get client port

            dsml = (DsmlClient) svc.getDsmlClientPort();

            // set the end point address

            ((Stub)dsml)._setProperty(

                "javax.xml.rpc.service.endpoint.address",

                        "http://localhost:8080/novell-dsml/stream");

            // get doc builder factory

            factory =  DocumentBuilderFactory.newInstance();            

            // get doc builder

            builder = factory.newDocumentBuilder();

            // get doc

            doc = builder.newDocument();

            

        }

        catch(Exception e) {

            System.out.println("Error in 'setDomClientObj' of " 

                                      + "DomClientObj: " + e.toString());

        }

    }



    public void setAuthProperties(String dn, String pwd) {

        // set authentication property

        ((Stub)dsml)._setProperty("javax.xml.rpc.security.auth.username",dn);

        ((Stub)dsml)._setProperty("javax.xml.rpc.security.auth.password",pwd);

    }



    public void saveElement(Element e) {

        saveElement(e, v, identation);

    }



    /*

     * SaveElement is used to parse DOM Element and save the parsed

     * dsml lines into Vector v with dsml format. 

     */

    public void saveElement(Element element, Vector v, String iden) {



        // prepare element text: starting tag and node name

        String eText = new String( iden + "<" + element.getNodeName());



        // prepare element text: attribute names and values

        NamedNodeMap nodeMap = element.getAttributes();

        int attrNum = nodeMap.getLength();



        for (int i=0; i<attrNum; i++) {

            Attr attr = (Attr)nodeMap.item(i);

            eText += " " + attr.getNodeName()+"=\"" + attr.getNodeValue() + "\"";

        }



        // save element text

        v.addElement(eText + ">");



        // go through any child node

        for ( Node cNode = element.getFirstChild();

              cNode != null;

              cNode = cNode.getNextSibling()) {



            int nodeType = cNode.getNodeType();           



            // increment identation for next node

            iden += "  ";



            if (nodeType == Node.ELEMENT_NODE) {

                // cNode is an element, recursive call

                saveElement((Element)cNode, v, iden);

            }

            else if (nodeType == Node.TEXT_NODE) {

                // prepare text node text

                String nText = cNode.getNodeValue().trim();

                // print text node text

                if(nText.length() > 0) {                    

                    v.addElement(iden + nText);

                }

            }

            

            // decrement identation for closing the node

            iden = iden.substring(2);

        }

                    

        v.addElement(iden + "</" + element.getNodeName() + ">");

        

        if (iden.length() > 2) {

            // decrement identation for closing the element

            iden = iden.substring(2);

        }       

    }



    public void saveMessage(String msg) {

        v.addElement(msg);

    }



    public Document getDocObj() {

        return doc;

    }



    public DsmlClient getDSML() {

        return dsml;

    }



    public DocumentBuilder getBuilder() {

        return builder;

    }

     

    public String[] getDSMLLines() {

        String[] s = new String[v.size()];

	v.copyInto(s);

        return s;

    }

}

