/* **************************************************************************

 * $OpenLDAP$

 *

 * Copyright (C) 2003 Novell, Inc. All Rights Reserved.

 *

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE, MODIFICATION, AND REDISTRIBUTION OF THIS WORK IS SUBJECT

 * TO VERSION 2.0.1 OF THE OPENLDAP PUBLIC LICENSE, A COPY OF WHICH IS

 * AVAILABLE AT HTTP://WWW.OPENLDAP.ORG/LICENSE.HTML OR IN THE FILE "LICENSE"

 * IN THE TOP-LEVEL DIRECTORY OF THE DISTRIBUTION. ANY USE OR EXPLOITATION

 * OF THIS WORK OTHER THAN AS AUTHORIZED IN VERSION 2.0.1 OF THE OPENLDAP

 * PUBLIC LICENSE, OR OTHER PRIOR WRITTEN CONSENT FROM NOVELL, COULD SUBJECT

 * THE PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.

 ***************************************************************************/

package sample_consumers;



import java.rmi.Remote;

import java.rmi.RemoteException;

import org.w3c.dom.Element;





/**

 * Interface for clients consuming the dsml service.  Note that this remote

 * interface must be generated to communicate via soap with binding properties

 * of 'document' and encoding as 'literal'.  This is done with the JBroker

 * tool, rmi2soap:

 * rmi2soap -document -literal com.novell.services.dsml.DsmlClient

 *

 * Also note that this interface differs from the orginal interface that

 * generates the DSML service.  It differs because the string method is not

 * originally specified.  However, because 'document' and 'literal' are

 * specified, both interfaces can be used for the service.

 *

 */

public interface DsmlClient extends Remote

{

    Element batchRequest(Element request) throws RemoteException;

}

