/* **************************************************************************

 * $OpenLDAP$

 *

 * Copyright (C) 2003 Novell, Inc. All Rights Reserved.

 *

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE, MODIFICATION, AND REDISTRIBUTION OF THIS WORK IS SUBJECT

 * TO VERSION 2.0.1 OF THE OPENLDAP PUBLIC LICENSE, A COPY OF WHICH IS

 * AVAILABLE AT HTTP://WWW.OPENLDAP.ORG/LICENSE.HTML OR IN THE FILE "LICENSE"

 * IN THE TOP-LEVEL DIRECTORY OF THE DISTRIBUTION. ANY USE OR EXPLOITATION

 * OF THIS WORK OTHER THAN AS AUTHORIZED IN VERSION 2.0.1 OF THE OPENLDAP

 * PUBLIC LICENSE, OR OTHER PRIOR WRITTEN CONSENT FROM NOVELL, COULD SUBJECT

 * THE PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.

 ***************************************************************************/

package sample_consumers;



import javax.naming.Context;

import javax.naming.NamingEnumeration;

import javax.naming.directory.SearchResult;

import javax.naming.directory.Attributes;

import javax.naming.directory.InitialDirContext;

import javax.naming.directory.DirContext;

import java.util.Hashtable;



/**

 * Search - This sample code allows you to do a search of a DSML server.

 * To run this code agains a DSML server you need to download DSML service

 * provider and the Java XML Pack both from Sun.

 * See:

 * http://developer.java.sun.com/developer/earlyAccess/jndi/

 * http://java.sun.com/xml/downloads/javaxmlpack.html

 *

 * These downloads will provide documentation, sample code and jar files needed

 * to talk to a DSML server. Make sure you read the documentation and put

 * jar files in your classpath.

 *

 * All of the samples in the Novell Boost Pack for JNDI can be used to test a

 * Novell DSML server by changing the following line in them from:

 * env.put(Context.INITIAL_CONTEXT_FACTORY,"com.sun.jndi.ldap.LdapCtxFactory");

 * to:

 * env.put(Context.INITIAL_CONTEXT_FACTORY,"com.sun.jndi.dsmlv2.soap.DsmlSoapCtxFactory");

 *   

 */ 

 



public class Search

{

    public static void main(String[] args)

    {

        if (args.length != 5)

        {

            System.err.print  ("Usage: java sample_consumers.Search ");

            System.err.print  ("<url to host> <login dn> <password> ");

            System.err.println("<dn to search> <search filter>");

            System.err.println("Example:");

            System.err.print  ("java sample_consumers.Search ");

            System.err.print  ("http://Acme.com:8080/novell-dsml/stream ");

            System.err.print  ("\"cn=admin,o=Acme\" \"secret\" \"o=Acme\" ");

            System.err.println("\"(objectclass=*)\"");

            System.exit(0);

        }



        String            url          = args[0];

        String            loginDN      = args[1];

        String            password     = args[2];

        String            searchDN     = args[3];

        String            searchFilter = args[4];

        String            factory      = null;

        DirContext        ctx          = null;

        NamingEnumeration results      = null;

        Hashtable         env          = null;



        try

        {

            env = new Hashtable();



            // Use DSML service provider from Sun

            env.put(Context.INITIAL_CONTEXT_FACTORY,

                    "com.sun.jndi.dsmlv2.soap.DsmlSoapCtxFactory");

            

            // Use LDAP service provider from Sun

            //env.put(Context.INITIAL_CONTEXT_FACTORY,

            //      "com.sun.jndi.ldap.LdapCtxFactory");

            

            env.put(Context.PROVIDER_URL, url);

            env.put(Context.SECURITY_PRINCIPAL, loginDN);

            env.put(Context.SECURITY_CREDENTIALS, password);

            ctx = new InitialDirContext(env);

            System.out.println("*** Searching on: " +

                                searchDN +

                                " with search Filter: " +

                                searchFilter + " ***");

            results = ctx.search(searchDN, searchFilter, null);

            while (results.hasMore()) {

                

                // get next result

                SearchResult result = (SearchResult)results.next();

                System.out.println("\nEntry name: " + result.getName());

                System.out.println("  Attributes:");

                

                // get attributes

                Attributes attrs = result.getAttributes();

                

                // get attribute id enumeration

                NamingEnumeration ids = attrs.getIDs();

                

                // print out each attribute

                while(ids.hasMore()) {

                    String id = (String)ids.next();

                    System.out.println("    " + attrs.get(id));

                }

            }

        }

        catch (Exception e)

        {

            System.out.println(e);

            e.printStackTrace();

        }

    }

} // end class Search



