/*******************************************************************************

 * $Novell: Dsml2Ldap.java,v 1.8 2003/08/21 11:49:20 $

 * Copyright (c) 2000 Novell, Inc. All Rights Reserved.

 *

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE

 * AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS

 * THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO

 * DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE

 * CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS

 * TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF

 * DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR

 * DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE.

 *

 * $name:         Dsml2Ldap.java

 * $description:  The Dsml2Ldap.java demonstrates how to use the

 * reader and writer interfaces to read a dsml file and apply its contents

 * to an LDAP directory.  It reads data from a stream object (file).

 ******************************************************************************/



import com.novell.ldap.*;



import com.novell.ldap.util.DSMLWriter;

import com.novell.ldap.util.LDAPWriter;

import com.novell.ldap.util.LDAPReader;

import com.novell.ldap.util.DSMLReader;



import java.io.FileNotFoundException;

import java.io.FileOutputStream;

import java.io.IOException;

import java.io.UnsupportedEncodingException;



public class Dsml2Ldap

{

    public static void main( String[] args )

    {

        if (args.length != 4 && args.length != 5) {

            System.err.println("Usage:   java Dsml2Ldap <host name>"

            					+ " <login dn> <password>"

            					+ " <dsmlFileIN> [<dsmlFileOUT>]");

            System.err.println("Example: java Dsml2Ldap Acme.com"

                                    + " \"cn=admin,o=Acme\""

                                    + " secret search.dsml results.dsml");

            System.exit(1);

        }



        int ldapPort = LDAPConnection.DEFAULT_PORT;

        int ldapVersion = LDAPConnection.LDAP_V3;

        LDAPConnection lc = new LDAPConnection();

        String ldapHost = args[0];

        String loginDN = args[1];

        String password = args[2];

        String inFile = args[3];

        String outFile = null;

        if (args.length == 5) {

            outFile = args[4];

        }



        try {

            // connect to the server

            lc.connect( ldapHost, ldapPort );

            // authenticate to the server

            lc.bind(ldapVersion, loginDN, password.getBytes("UTF8") );



            DSMLWriter out;

            FileOutputStream outFileStream = null;

            if (outFile == null){

                out = new DSMLWriter(System.out);

            } else {

                outFileStream = new FileOutputStream(outFile);

                out = new DSMLWriter(outFileStream);

            }

            out.useIndent(true);

            out.setIndent(4);



            LDAPReader in = new DSMLReader(inFile);

            LDAPMessage inMessage, outMessage;



            inMessage = in.readMessage();

            while( inMessage != null ){

                LDAPMessageQueue queue =

                    lc.sendRequest( inMessage, null, null);

                while (( outMessage = queue.getResponse()) != null ) {

                    out.writeMessage( outMessage );

                }

                inMessage = in.readMessage();

            }

            // Write closing dsml output

            out.finish();



            // Close the file

            if (outFile != null) {

                outFileStream.close();

            }



            // disconnect with the server

            lc.disconnect();

        }catch( UnsupportedEncodingException e ) {

            System.out.println( "Error: " + e.toString() );

        }catch (FileNotFoundException e) {

            System.out.println( "Error: could not find input DSML file:" + e );

        } catch (IOException e) {

            System.out.println( "Error reading or writing to file:" + e);

        } catch (LDAPLocalException e) {

            System.out.println(

                    "The following error occured handling a DSML file:" + e);

        } catch (LDAPException e) {

            System.out.println(

                    "The following error occured on the server:" + e);

        }

        System.exit(0);

    }

}

