/* **************************************************************************

 * $Novell: ChangeReplicaType.java,v 1.18 2003/08/21 11:51:40 $

 *

 * Copyright (C) 1999, 2000, 2001 Novell, Inc. All Rights Reserved.

 * 

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE

 * AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS

 * THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO

 * DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE

 * CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS

 * TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF

 * DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR

 * DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE. 

 ***************************************************************************/

import com.novell.ldap.LDAPConnection;

import com.novell.ldap.LDAPException;

import com.novell.ldap.LDAPExtendedOperation;

import com.novell.ldap.LDAPExtendedResponse;

import com.novell.ldap.extensions.ChangeReplicaTypeRequest;

import com.novell.ldap.extensions.ReplicationConstants;

import java.io.UnsupportedEncodingException;



/**

 *  The following sample demonstrates how to change the type of

 *  the replica that resides on a specific LDAP server using 

 *  Novell LDAP extensions.

 */

public class ChangeReplicaType {



    public static void main( String[] args ) {



        if (args.length != 7) {

            System.err.println("Usage:   java ChangeReplicaType <host Name> "

                              + "<port number> <login dn> <password>\n        "

                              + " <replica dn> <replica type> <server ND>");

            System.err.println("Example: java ChangeReplicaType Acme.com 389 "

                              + "\"cn=Admin,o=Acme\" secret\n         "

                              + "\"ou=Sales,o=Acme\" 2 \"cn=myServer,o=Acme\"");

            System.exit(1);

        }



        int    ldapVersion = LDAPConnection.LDAP_V3;

        String ldapHost    = args[0];

        int    ldapPort    = Integer.parseInt(args[1]);

        String loginDN     = args[2];

        String password    = args[3];

        String replicaDN   = args[4];

        int    replicaType = Integer.parseInt(args[5]);

        String serverDN    = args[6];

        LDAPConnection ld  = new LDAPConnection();



        try {

            // connect to the server

            ld.connect( ldapHost, ldapPort);

            // bind to the server

            ld.bind( ldapVersion, loginDN, password.getBytes("UTF8") );

            System.out.println( "\nLogin succeeded");



            LDAPExtendedOperation request = new ChangeReplicaTypeRequest(

                                replicaDN, 

                                serverDN, 

                                replicaType, 

                                ReplicationConstants.LDAP_ENSURE_SERVERS_UP);

            

            LDAPExtendedResponse response = ld.extendedOperation(request);            



            if ( response.getResultCode() == LDAPException.SUCCESS ) {

                System.out.println("Change Replica Type Request succeeded\n");

            } else {                

                System.out.println("Change Replica Type Request Failed");

                throw new LDAPException( response.getErrorMessage(),

                                         response.getResultCode(),

                                         (String)null);

            }



            /* Done, so disconnect */

            if ( ld.isConnected() )

                ld.disconnect();

        }

        catch( LDAPException e ) {

            System.out.println( "Error: " + e.toString() );

        }

        catch( UnsupportedEncodingException e ) {

            System.out.println( "Error: " + e.toString() );

        }

    }

}

