/* **************************************************************************

 * $Novell: GetX500Dn.java,v 1.3 2007/08/08  $

 *

 * Copyright (C) 2007 Novell, Inc. All Rights Reserved.

 * 

 * THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND

 * TREATIES. USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE

 * AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS

 * THIS WORK. PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO

 * DEVELOPER A ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE

 * CODE IN ITS PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS

 * TO MARKET, DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF

 * DEVELOPER'S PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR

 * DEVELOPER'S CUSTOMERS WITH RESPECT TO THIS CODE. 

 ***************************************************************************/
import java.io.UnsupportedEncodingException;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPExtendedOperation;
import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.extensions.LDAPDnsToX500DNRequest;
import com.novell.ldap.extensions.LDAPDnsToX500DNResponse;

public class GetX500Dn {
	
	GetX500Dn()
	{
		super();
	}
	public static void main(String[] args) 
	{
		if (args.length != 5 ) {
	            System.err.println("Usage: java GetX500Dn <host Name> "+"<port number> <login dn> <password>\n "
	                              + " <object DN> " );
	            System.err.println("Example: java GetX500Dn Acme.com 389 " + "\"cn=Admin,o=Acme\" secret\n "
	                              + "\"cn=TestUser,o=Acme\"");
	           System.exit(1);
		}

		int ldapVersion = LDAPConnection.LDAP_V3;
		String ldapHost = args[0];
		int ldapPort = Integer.parseInt(args[1]);
		String loginDN = args[2];
		String password = args[3];
		String objectDN = args[4];

		//Create a LDAPConnection object
		LDAPConnection ld = new LDAPConnection();
		try 
		{
			 // connect to the server
            ld.connect( ldapHost, ldapPort);
            // bind to the server
            ld.bind( ldapVersion, loginDN, password.getBytes("UTF8") );
            System.out.println( "\nLogin succeeded");
            LDAPExtendedOperation request = new LDAPDnsToX500DNRequest(objectDN);
            LDAPExtendedResponse response = ld.extendedOperation(request);
            if (((response.getResultCode()) == LDAPException.SUCCESS )&&(response instanceof LDAPDnsToX500DNResponse))
            {
            	System.out.println("The name mapped DN is : "+ ((LDAPDnsToX500DNResponse)response).getX500DN());
                System.out.println("\n succeeded.\n");
            }
            else 
            {
                System.out.println("Namemapped DN failed.\n");
                throw new LDAPException( response.getErrorMessage(),response.getResultCode(),(String)null);
           }

            /* Done, so disconnect */
            if ( ld.isConnected() )
                ld.disconnect();
        }
        catch( LDAPException e ) {
        	e.printStackTrace();
            System.out.println( "\n\tError: " + e.toString());
        }
        catch( UnsupportedEncodingException e ) {
            System.out.println( "Error: " + e.toString() );
        }
	}
}
